/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.TrafficType;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListNetworksOptionsTest {
    public void testIsDefault() {
        ListNetworksOptions options = new ListNetworksOptions().isDefault(true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"isdefault"));
    }

    public void testIsDefaultStatic() {
        ListNetworksOptions options = ListNetworksOptions.Builder.isDefault((boolean)true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"isdefault"));
    }

    public void testIsSystem() {
        ListNetworksOptions options = new ListNetworksOptions().isSystem(true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"issystem"));
    }

    public void testIsSystemStatic() {
        ListNetworksOptions options = ListNetworksOptions.Builder.isSystem((boolean)true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"issystem"));
    }

    public void testIsShared() {
        ListNetworksOptions options = new ListNetworksOptions().isShared(true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"isshared"));
    }

    public void testIsSharedStatic() {
        ListNetworksOptions options = ListNetworksOptions.Builder.isShared((boolean)true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"isshared"));
    }

    public void testId() {
        ListNetworksOptions options = new ListNetworksOptions().id(6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testIdStatic() {
        ListNetworksOptions options = ListNetworksOptions.Builder.id((long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testDomainId() {
        ListNetworksOptions options = new ListNetworksOptions().domainId(6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testDomainIdStatic() {
        ListNetworksOptions options = ListNetworksOptions.Builder.domainId((long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testAccountId() {
        ListNetworksOptions options = new ListNetworksOptions().accountInDomain("moo", 1L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testAccountIdStatic() {
        ListNetworksOptions options = ListNetworksOptions.Builder.accountInDomain((String)"moo", (long)1L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"moo"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testTrafficType() {
        ListNetworksOptions options = new ListNetworksOptions().trafficType(TrafficType.GUEST);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Guest"), (Collection)options.buildQueryParameters().get((Object)"traffictype"));
    }

    public void testTrafficTypeStatic() {
        ListNetworksOptions options = ListNetworksOptions.Builder.trafficType((TrafficType)TrafficType.GUEST);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Guest"), (Collection)options.buildQueryParameters().get((Object)"traffictype"));
    }

    public void testName() {
        ListNetworksOptions options = new ListNetworksOptions().id(6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testNameStatic() {
        ListNetworksOptions options = ListNetworksOptions.Builder.id((long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testZoneId() {
        ListNetworksOptions options = new ListNetworksOptions().zoneId(6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }

    public void testZoneIdStatic() {
        ListNetworksOptions options = ListNetworksOptions.Builder.zoneId((long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }

    public void testType() {
        ListNetworksOptions options = new ListNetworksOptions().type(NetworkType.ADVANCED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Advanced"), (Collection)options.buildQueryParameters().get((Object)"type"));
    }

    public void testTypeStatic() {
        ListNetworksOptions options = ListNetworksOptions.Builder.type((NetworkType)NetworkType.ADVANCED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Advanced"), (Collection)options.buildQueryParameters().get((Object)"type"));
    }
}

