/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import java.util.Date;

public class Alert
implements Comparable<Alert> {
    private long id;
    private String description;
    private Date sent;
    private String type;

    public static Builder builder() {
        return new Builder();
    }

    Alert() {
    }

    private Alert(long id, String description, Date sent, String type) {
        this.id = id;
        this.description = description;
        this.sent = sent;
        this.type = type;
    }

    public long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getSent() {
        return this.sent;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Alert alert = (Alert)o;
        if (this.id != alert.id) {
            return false;
        }
        if (this.description != null ? !this.description.equals(alert.description) : alert.description != null) {
            return false;
        }
        if (this.sent != null ? !this.sent.equals(alert.sent) : alert.sent != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(alert.type) : alert.type != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.sent != null ? this.sent.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Alert{id=" + this.id + ", description='" + this.description + '\'' + ", sent=" + this.sent + ", type='" + this.type + '\'' + '}';
    }

    @Override
    public int compareTo(Alert other) {
        return Long.valueOf(this.getId()).compareTo(other.getId());
    }

    public static class Builder {
        private long id;
        private String description;
        private Date sent;
        private String type;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder sent(Date sent) {
            this.sent = sent;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Alert build() {
            return new Alert(this.id, this.description, this.sent, this.type);
        }
    }
}

