/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Date;

public class ISO
implements Comparable<ISO> {
    private long id;
    private String account;
    @SerializedName(value="accountid")
    private long accountId;
    private boolean bootable;
    private String checksum;
    private Date created;
    private boolean crossZones;
    @SerializedName(value="displaytext")
    private String displayText;
    private String domain;
    @SerializedName(value="domainId")
    private long domainid;
    private String format;
    @SerializedName(value="hostid")
    private long hostId;
    @SerializedName(value="hostname")
    private String hostName;
    private String hypervisor;
    @SerializedName(value="isextractable")
    private boolean isExtractable;
    @SerializedName(value="isfeatured")
    private boolean isFeatured;
    @SerializedName(value="ispublic")
    private boolean isPublic;
    @SerializedName(value="isready")
    private boolean isReady;
    @SerializedName(value="jobid")
    private long jobId;
    @SerializedName(value="jobstatus")
    private String jobStatus;
    private String name;
    @SerializedName(value="ostypeid")
    private long osTypeId;
    @SerializedName(value="ostypename")
    private String osTypeName;
    @SerializedName(value="passwordenabled")
    private boolean passwordEnabled;
    private Date removed;
    private long size;
    @SerializedName(value="sourcetemplateid")
    private long sourceTemplateId;
    private String status;
    @SerializedName(value="templatetag")
    private String templateTag;
    @SerializedName(value="templatetype")
    private String templateType;
    @SerializedName(value="zoneid")
    private long zoneId;
    @SerializedName(value="zonename")
    private String zoneName;

    public static Builder builder() {
        return new Builder();
    }

    ISO() {
    }

    public long getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public boolean getBootable() {
        return this.bootable;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean getCrossZones() {
        return this.crossZones;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainid() {
        return this.domainid;
    }

    public String getFormat() {
        return this.format;
    }

    public long getHostId() {
        return this.hostId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public boolean getIsExtractable() {
        return this.isExtractable;
    }

    public boolean getIsFeatured() {
        return this.isFeatured;
    }

    public boolean getIsPublic() {
        return this.isPublic;
    }

    public boolean getIsReady() {
        return this.isReady;
    }

    public long getJobId() {
        return this.jobId;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public String getName() {
        return this.name;
    }

    public long getOsTypeId() {
        return this.osTypeId;
    }

    public String getOsTypeName() {
        return this.osTypeName;
    }

    public boolean getPasswordEnabled() {
        return this.passwordEnabled;
    }

    public Date getRemoved() {
        return this.removed;
    }

    public long getSize() {
        return this.size;
    }

    public long getSourceTemplateId() {
        return this.sourceTemplateId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getTemplateTag() {
        return this.templateTag;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ISO iso = (ISO)o;
        if (this.accountId != iso.accountId) {
            return false;
        }
        if (this.bootable != iso.bootable) {
            return false;
        }
        if (this.crossZones != iso.crossZones) {
            return false;
        }
        if (this.domainid != iso.domainid) {
            return false;
        }
        if (this.hostId != iso.hostId) {
            return false;
        }
        if (this.id != iso.id) {
            return false;
        }
        if (this.isExtractable != iso.isExtractable) {
            return false;
        }
        if (this.isFeatured != iso.isFeatured) {
            return false;
        }
        if (this.isPublic != iso.isPublic) {
            return false;
        }
        if (this.isReady != iso.isReady) {
            return false;
        }
        if (this.jobId != iso.jobId) {
            return false;
        }
        if (this.osTypeId != iso.osTypeId) {
            return false;
        }
        if (this.passwordEnabled != iso.passwordEnabled) {
            return false;
        }
        if (this.size != iso.size) {
            return false;
        }
        if (this.sourceTemplateId != iso.sourceTemplateId) {
            return false;
        }
        if (this.zoneId != iso.zoneId) {
            return false;
        }
        if (this.account != null ? !this.account.equals(iso.account) : iso.account != null) {
            return false;
        }
        if (this.checksum != null ? !this.checksum.equals(iso.checksum) : iso.checksum != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(iso.created) : iso.created != null) {
            return false;
        }
        if (this.displayText != null ? !this.displayText.equals(iso.displayText) : iso.displayText != null) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(iso.domain) : iso.domain != null) {
            return false;
        }
        if (this.format != null ? !this.format.equals(iso.format) : iso.format != null) {
            return false;
        }
        if (this.hostName != null ? !this.hostName.equals(iso.hostName) : iso.hostName != null) {
            return false;
        }
        if (this.hypervisor != null ? !this.hypervisor.equals(iso.hypervisor) : iso.hypervisor != null) {
            return false;
        }
        if (this.jobStatus != null ? !this.jobStatus.equals(iso.jobStatus) : iso.jobStatus != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(iso.name) : iso.name != null) {
            return false;
        }
        if (this.osTypeName != null ? !this.osTypeName.equals(iso.osTypeName) : iso.osTypeName != null) {
            return false;
        }
        if (this.removed != null ? !this.removed.equals(iso.removed) : iso.removed != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(iso.status) : iso.status != null) {
            return false;
        }
        if (this.templateTag != null ? !this.templateTag.equals(iso.templateTag) : iso.templateTag != null) {
            return false;
        }
        if (this.templateType != null ? !this.templateType.equals(iso.templateType) : iso.templateType != null) {
            return false;
        }
        return !(this.zoneName != null ? !this.zoneName.equals(iso.zoneName) : iso.zoneName != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
        result = 31 * result + (int)(this.accountId ^ this.accountId >>> 32);
        result = 31 * result + (this.bootable ? 1 : 0);
        result = 31 * result + (this.checksum != null ? this.checksum.hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.crossZones ? 1 : 0);
        result = 31 * result + (this.displayText != null ? this.displayText.hashCode() : 0);
        result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
        result = 31 * result + (int)(this.domainid ^ this.domainid >>> 32);
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (int)(this.hostId ^ this.hostId >>> 32);
        result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
        result = 31 * result + (this.hypervisor != null ? this.hypervisor.hashCode() : 0);
        result = 31 * result + (this.isExtractable ? 1 : 0);
        result = 31 * result + (this.isFeatured ? 1 : 0);
        result = 31 * result + (this.isPublic ? 1 : 0);
        result = 31 * result + (this.isReady ? 1 : 0);
        result = 31 * result + (int)(this.jobId ^ this.jobId >>> 32);
        result = 31 * result + (this.jobStatus != null ? this.jobStatus.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (int)(this.osTypeId ^ this.osTypeId >>> 32);
        result = 31 * result + (this.osTypeName != null ? this.osTypeName.hashCode() : 0);
        result = 31 * result + (this.passwordEnabled ? 1 : 0);
        result = 31 * result + (this.removed != null ? this.removed.hashCode() : 0);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.sourceTemplateId ^ this.sourceTemplateId >>> 32);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.templateTag != null ? this.templateTag.hashCode() : 0);
        result = 31 * result + (this.templateType != null ? this.templateType.hashCode() : 0);
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (this.zoneName != null ? this.zoneName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ISO{id=" + this.id + ", account='" + this.account + '\'' + ", accountId=" + this.accountId + ", bootable=" + this.bootable + ", checksum='" + this.checksum + '\'' + ", created=" + this.created + ", crossZones=" + this.crossZones + ", displayText='" + this.displayText + '\'' + ", domain='" + this.domain + '\'' + ", domainid=" + this.domainid + ", format='" + this.format + '\'' + ", hostId=" + this.hostId + ", hostName='" + this.hostName + '\'' + ", hypervisor='" + this.hypervisor + '\'' + ", isExtractable=" + this.isExtractable + ", isFeatured=" + this.isFeatured + ", isPublic=" + this.isPublic + ", isReady=" + this.isReady + ", jobId=" + this.jobId + ", jobStatus='" + this.jobStatus + '\'' + ", name='" + this.name + '\'' + ", osTypeId=" + this.osTypeId + ", osTypeName='" + this.osTypeName + '\'' + ", passwordEnabled=" + this.passwordEnabled + ", removed=" + this.removed + ", size=" + this.size + ", sourceTemplateId=" + this.sourceTemplateId + ", status='" + this.status + '\'' + ", templateTag='" + this.templateTag + '\'' + ", templateType='" + this.templateType + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + '}';
    }

    @Override
    public int compareTo(ISO other) {
        return new Long(this.id).compareTo(other.getId());
    }

    public static enum ISOFilter {
        featured,
        self,
        self_executable,
        executable,
        community,
        UNRECOGNIZED;


        public static ISOFilter fromValue(String format) {
            try {
                return ISOFilter.valueOf((String)Preconditions.checkNotNull((Object)format, (Object)"format"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private long id;
        private String account;
        private long accountId;
        private boolean bootable;
        private String checksum;
        private Date created;
        private boolean crossZones;
        private String displayText;
        private String domain;
        private long domainid;
        private String format;
        private long hostId;
        private String hostName;
        private String hypervisor;
        private boolean isExtractable;
        private boolean isFeatured;
        private boolean isPublic;
        private boolean isReady;
        private long jobId;
        private String jobStatus;
        private String name;
        private long osTypeId;
        private String osTypeName;
        private boolean passwordEnabled;
        private Date removed;
        private long size;
        private long sourceTemplateId;
        private String status;
        private String templateTag;
        private String templateType;
        private long zoneId;
        private String zoneName;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder accountId(long accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder bootable(boolean bootable) {
            this.bootable = bootable;
            return this;
        }

        public Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder crossZones(boolean crossZones) {
            this.crossZones = crossZones;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainid(long domainid) {
            this.domainid = domainid;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder hostId(long hostId) {
            this.hostId = hostId;
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder isExtractable(boolean isExtractable) {
            this.isExtractable = isExtractable;
            return this;
        }

        public Builder isFeatured(boolean isFeatured) {
            this.isFeatured = isFeatured;
            return this;
        }

        public Builder isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public Builder isReady(boolean isReady) {
            this.isReady = isReady;
            return this;
        }

        public Builder jobId(long jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder osTypeId(long osTypeId) {
            this.osTypeId = osTypeId;
            return this;
        }

        public Builder osTypeName(String osTypeName) {
            this.osTypeName = osTypeName;
            return this;
        }

        public Builder passwordEnabled(boolean passwordEnabled) {
            this.passwordEnabled = passwordEnabled;
            return this;
        }

        public Builder removed(Date removed) {
            this.removed = removed;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder sourceTemplateId(long sourceTemplateId) {
            this.sourceTemplateId = sourceTemplateId;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder templateTag(String templateTag) {
            this.templateTag = templateTag;
            return this;
        }

        public Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }
    }
}

