/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.features.BaseCloudStackRestClientExpectTest;
import org.jclouds.cloudstack.features.ZoneClient;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ZoneClientExpectTest")
public class ZoneClientExpectTest
extends BaseCloudStackRestClientExpectTest<ZoneClient> {
    public void testListZonesWhenResponseIs2xx() {
        ZoneClient client = (ZoneClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listZones&apiKey=identity&signature=wLSqVlxuiLXZcHi9IoSAwXNRGFs%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listzonesresponse.json")).build());
        Assert.assertEquals((Set)client.listZones(new ListZonesOptions[0]), (Set)ImmutableSet.of((Object)Zone.builder().id(1L).name("San Jose 1").networkType(NetworkType.ADVANCED).securityGroupsEnabled(false).build(), (Object)Zone.builder().id(2L).name("Chicago").networkType(NetworkType.ADVANCED).securityGroupsEnabled(true).build()));
    }

    public void testListZonesWhenResponseIs404() {
        ZoneClient client = (ZoneClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listZones&apiKey=identity&signature=wLSqVlxuiLXZcHi9IoSAwXNRGFs%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listZones(new ListZonesOptions[0]), (Set)ImmutableSet.of());
    }

    @Override
    protected ZoneClient clientFrom(CloudStackContext context) {
        return ((CloudStackClient)context.getProviderSpecificContext().getApi()).getZoneClient();
    }
}

