/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.jclouds.cloudstack.options.CreateVlanIPRangeOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CreateVlanIPRangeOptionsTest {
    public void testAccountInDomain() {
        CreateVlanIPRangeOptions options = new CreateVlanIPRangeOptions().accountInDomain("fred", 6L);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"fred"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testAccountInDomainStatic() {
        CreateVlanIPRangeOptions options = CreateVlanIPRangeOptions.Builder.accountInDomain((String)"fred", (long)6L);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"fred"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testDomainId() {
        CreateVlanIPRangeOptions options = new CreateVlanIPRangeOptions().domainId(6L);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testDomainIdStatic() {
        CreateVlanIPRangeOptions options = CreateVlanIPRangeOptions.Builder.domainId((long)6L);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testForVirtualNetwork() {
        CreateVlanIPRangeOptions options = new CreateVlanIPRangeOptions().forVirtualNetwork(true);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"forvirtualnetwork"));
    }

    public void testForVirtualNetworkStatic() {
        CreateVlanIPRangeOptions options = CreateVlanIPRangeOptions.Builder.forVirtualNetwork((boolean)true);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"forvirtualnetwork"));
    }

    public void testGateway() {
        CreateVlanIPRangeOptions options = new CreateVlanIPRangeOptions().gateway("192.168.42.24");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"192.168.42.24"), (Collection)options.buildQueryParameters().get((Object)"gateway"));
    }

    public void testGatewayStatic() {
        CreateVlanIPRangeOptions options = CreateVlanIPRangeOptions.Builder.gateway((String)"192.168.42.24");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"192.168.42.24"), (Collection)options.buildQueryParameters().get((Object)"gateway"));
    }

    public void testNetmask() {
        CreateVlanIPRangeOptions options = new CreateVlanIPRangeOptions().netmask("255.255.255.240");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"255.255.255.240"), (Collection)options.buildQueryParameters().get((Object)"netmask"));
    }

    public void testNetmaskStatic() {
        CreateVlanIPRangeOptions options = CreateVlanIPRangeOptions.Builder.netmask((String)"255.255.255.240");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"255.255.255.240"), (Collection)options.buildQueryParameters().get((Object)"netmask"));
    }

    public void testNetworkId() {
        CreateVlanIPRangeOptions options = new CreateVlanIPRangeOptions().networkId(9L);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"9"), (Collection)options.buildQueryParameters().get((Object)"networkid"));
    }

    public void testNetworkIdStatic() {
        CreateVlanIPRangeOptions options = CreateVlanIPRangeOptions.Builder.networkId((long)9L);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"9"), (Collection)options.buildQueryParameters().get((Object)"networkid"));
    }

    public void testPodId() {
        CreateVlanIPRangeOptions options = new CreateVlanIPRangeOptions().podId(8L);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"8"), (Collection)options.buildQueryParameters().get((Object)"podid"));
    }

    public void testPodIdStatic() {
        CreateVlanIPRangeOptions options = CreateVlanIPRangeOptions.Builder.podId((long)8L);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"8"), (Collection)options.buildQueryParameters().get((Object)"podid"));
    }

    public void testVlan() {
        CreateVlanIPRangeOptions options = new CreateVlanIPRangeOptions().vlan(1001L);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"1001"), (Collection)options.buildQueryParameters().get((Object)"vlan"));
    }

    public void testVlanStatic() {
        CreateVlanIPRangeOptions options = CreateVlanIPRangeOptions.Builder.vlan((long)1001L);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"1001"), (Collection)options.buildQueryParameters().get((Object)"vlan"));
    }

    public void testZoneId() {
        CreateVlanIPRangeOptions options = new CreateVlanIPRangeOptions().zoneId(7L);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"7"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }

    public void testZoneIdStatic() {
        CreateVlanIPRangeOptions options = CreateVlanIPRangeOptions.Builder.zoneId((long)7L);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"7"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }
}

