/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.options.UpdateHostOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class UpdateHostOptionsTest {
    public void testAllocationState() {
        UpdateHostOptions options = new UpdateHostOptions().allocationState(AllocationState.ENABLED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Enabled"), (Collection)options.buildQueryParameters().get((Object)"allocationstate"));
    }

    public void testAllocationStateStatic() {
        UpdateHostOptions options = UpdateHostOptions.Builder.allocationState((AllocationState)AllocationState.ENABLED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Enabled"), (Collection)options.buildQueryParameters().get((Object)"allocationstate"));
    }

    public void testHostTags() {
        UpdateHostOptions options = new UpdateHostOptions().hostTags((Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"baz"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo,bar,baz"), (Collection)options.buildQueryParameters().get((Object)"hosttags"));
    }

    public void testHostTagsStatic() {
        UpdateHostOptions options = UpdateHostOptions.Builder.hostTags((Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"baz"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo,bar,baz"), (Collection)options.buildQueryParameters().get((Object)"hosttags"));
    }

    public void testOsCategoryId() {
        UpdateHostOptions options = new UpdateHostOptions().osCategoryId(42L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"42"), (Collection)options.buildQueryParameters().get((Object)"oscategoryid"));
    }

    public void testOsCategoryIdStatic() {
        UpdateHostOptions options = UpdateHostOptions.Builder.osCategoryId((long)42L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"42"), (Collection)options.buildQueryParameters().get((Object)"oscategoryid"));
    }
}

