/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jclouds.cloudstack.domain.AsyncJobError;

public class AsyncJob<T> {
    @SerializedName(value="accountid")
    private long accountId = -1L;
    private String cmd;
    private Date created;
    @SerializedName(value="jobid")
    private long id = -1L;
    @SerializedName(value="jobinstanceid")
    private long instanceId = -1L;
    @SerializedName(value="jobinstancetype")
    private String instanceType;
    @SerializedName(value="jobprocstatus")
    private int progress = -1;
    @SerializedName(value="jobresult")
    private T result;
    @SerializedName(value="jobresultcode")
    private ResultCode resultCode = ResultCode.UNKNOWN;
    @SerializedName(value="jobresulttype")
    private String resultType;
    @SerializedName(value="jobstatus")
    private Status status = Status.UNKNOWN;
    @SerializedName(value="userid")
    private int userId = -1;
    private AsyncJobError error;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public AsyncJob(long accountId, String cmd, Date created, long id, long instanceId, String instanceType, int progress, T result, ResultCode resultCode, String resultType, Status status, int userId, AsyncJobError error) {
        this.accountId = accountId;
        this.cmd = cmd;
        this.created = created;
        this.id = id;
        this.instanceId = instanceId;
        this.instanceType = instanceType;
        this.progress = progress;
        this.result = result;
        this.resultCode = resultCode;
        this.resultType = resultType;
        this.status = status;
        this.userId = userId;
        this.error = error;
    }

    AsyncJob() {
    }

    public long getAccountId() {
        return this.accountId;
    }

    public String getCmd() {
        return this.cmd;
    }

    public Date getCreated() {
        return this.created;
    }

    public long getId() {
        return this.id;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public int getProgress() {
        return this.progress;
    }

    public T getResult() {
        return this.result;
    }

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public String getResultType() {
        return this.resultType;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getUserId() {
        return this.userId;
    }

    public AsyncJobError getError() {
        return this.error;
    }

    public boolean hasFailed() {
        return this.getError() != null || this.getResultCode() == ResultCode.FAIL || this.getStatus() == Status.FAILED;
    }

    public boolean hasSucceed() {
        return this.getError() == null && this.getResultCode() == ResultCode.SUCCESS && this.getStatus() == Status.SUCCEEDED;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.accountId ^ this.accountId >>> 32);
        result = 31 * result + (this.cmd == null ? 0 : this.cmd.hashCode());
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.instanceId ^ this.instanceId >>> 32);
        result = 31 * result + (this.instanceType == null ? 0 : this.instanceType.hashCode());
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + this.progress;
        result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
        result = 31 * result + this.resultCode.code();
        result = 31 * result + (this.resultType == null ? 0 : this.resultType.hashCode());
        result = 31 * result + this.status.code();
        result = 31 * result + this.userId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncJob other = (AsyncJob)obj;
        if (this.accountId != other.accountId) {
            return false;
        }
        if (this.cmd == null ? other.cmd != null : !this.cmd.equals(other.cmd)) {
            return false;
        }
        if (this.created == null ? other.created != null : !this.created.equals(other.created)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.instanceId != other.instanceId) {
            return false;
        }
        if (this.instanceType == null ? other.instanceType != null : !this.instanceType.equals(other.instanceType)) {
            return false;
        }
        if (this.error == null ? other.error != null : !this.error.equals(other.error)) {
            return false;
        }
        if (this.progress != other.progress) {
            return false;
        }
        if (this.result == null ? other.result != null : !this.result.equals(other.result)) {
            return false;
        }
        if (this.resultCode != other.resultCode) {
            return false;
        }
        if (this.resultType == null ? other.resultType != null : !this.resultType.equals(other.resultType)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return this.userId == other.userId;
    }

    public String toString() {
        return "AsyncJob{accountId=" + this.accountId + ", cmd='" + this.cmd + '\'' + ", created=" + this.created + ", id=" + this.id + ", instanceId=" + this.instanceId + ", instanceType='" + this.instanceType + '\'' + ", progress=" + this.progress + ", result=" + this.result + ", resultCode=" + (Object)((Object)this.resultCode) + ", resultType='" + this.resultType + '\'' + ", status=" + (Object)((Object)this.status) + ", userId=" + this.userId + ", error=" + this.error + '}';
    }

    public static class Builder<T> {
        private long accountId = -1L;
        private String cmd;
        private Date created;
        private long id = -1L;
        private long instanceId = -1L;
        private String instanceType;
        private int progress = -1;
        private T result;
        private ResultCode resultCode = ResultCode.UNKNOWN;
        private String resultType;
        private AsyncJobError error;
        private Status status = Status.UNKNOWN;
        private int userId = -1;

        public Builder<T> accountId(long accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder<T> cmd(String cmd) {
            this.cmd = cmd;
            return this;
        }

        public Builder<T> created(Date created) {
            this.created = created;
            return this;
        }

        public Builder<T> id(long id) {
            this.id = id;
            return this;
        }

        public Builder<T> instanceId(long instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder<T> error(AsyncJobError error) {
            this.error = error;
            return this;
        }

        public Builder<T> instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder<T> progress(int progress) {
            this.progress = progress;
            return this;
        }

        public Builder<T> result(T result) {
            this.result = result;
            return this;
        }

        public Builder<T> resultCode(ResultCode resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        public Builder<T> resultType(String resultType) {
            this.resultType = resultType;
            return this;
        }

        public Builder<T> status(Status status) {
            this.status = status;
            return this;
        }

        public Builder<T> userId(int userId) {
            this.userId = userId;
            return this;
        }

        public AsyncJob<T> build() {
            return new AsyncJob<T>(this.accountId, this.cmd, this.created, this.id, this.instanceId, this.instanceType, this.progress, this.result, this.resultCode, this.resultType, this.status, this.userId, this.error);
        }

        public static <T> Builder<T> fromAsyncJobUntyped(AsyncJob<T> in) {
            return new Builder<T>().accountId(((AsyncJob)in).accountId).cmd(((AsyncJob)in).cmd).created(((AsyncJob)in).created).id(((AsyncJob)in).id).instanceId(((AsyncJob)in).instanceId).instanceType(((AsyncJob)in).instanceType).progress(((AsyncJob)in).progress).result(((AsyncJob)in).result).resultCode(((AsyncJob)in).resultCode).resultType(((AsyncJob)in).resultType).status(((AsyncJob)in).status).userId(((AsyncJob)in).userId).error(((AsyncJob)in).error);
        }
    }

    public static enum Status {
        IN_PROGRESS(0),
        SUCCEEDED(1),
        FAILED(2),
        UNKNOWN(-1);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static Status fromValue(String value) {
            try {
                int statusCode = Integer.parseInt(value);
                switch (statusCode) {
                    case 0: {
                        return IN_PROGRESS;
                    }
                    case 1: {
                        return SUCCEEDED;
                    }
                    case 2: {
                        return FAILED;
                    }
                }
                return UNKNOWN;
            }
            catch (NumberFormatException e) {
                return UNKNOWN;
            }
        }
    }

    public static enum ResultCode {
        SUCCESS(0),
        FAIL(530),
        UNKNOWN(-1);

        private final int code;

        private ResultCode(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static ResultCode fromValue(String value) {
            try {
                int resultCode = Integer.parseInt(value);
                switch (resultCode) {
                    case 0: {
                        return SUCCESS;
                    }
                    case 530: {
                        return FAIL;
                    }
                }
                return UNKNOWN;
            }
            catch (NumberFormatException e) {
                return UNKNOWN;
            }
        }
    }
}

