/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;
import org.jclouds.cloudstack.domain.Account;

public class LoginResponse
implements Comparable<LoginResponse> {
    private final String username;
    @SerializedName(value="userid")
    private final long userId;
    private final String password;
    @SerializedName(value="domainid")
    private final long domainId;
    private final long timeout;
    private final boolean registered;
    @SerializedName(value="account")
    private final String accountName;
    @SerializedName(value="firstname")
    private final String firstName;
    @SerializedName(value="lastname")
    private final String lastName;
    @SerializedName(value="type")
    private final Account.Type accountType;
    private final String timezone;
    @SerializedName(value="timezoneoffset")
    private final String timezoneOffset;
    @SerializedName(value="sessionkey")
    private final String sessionKey;
    private final String jSessionId;

    public static Builder builder() {
        return new Builder();
    }

    public LoginResponse(String username, long userId, String password, long domainId, long timeout, boolean registered, String accountName, String firstName, String lastName, Account.Type accountType, String timezone, String timezoneOffset, String sessionKey, String jSessionId) {
        this.username = username;
        this.userId = userId;
        this.password = password;
        this.domainId = domainId;
        this.timeout = timeout;
        this.registered = registered;
        this.accountName = accountName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.accountType = accountType;
        this.timezone = timezone;
        this.timezoneOffset = timezoneOffset;
        this.sessionKey = sessionKey;
        this.jSessionId = jSessionId;
    }

    public String getUsername() {
        return this.username;
    }

    public long getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Account.Type getAccountType() {
        return this.accountType;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public String getJSessionId() {
        return this.jSessionId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoginResponse other = (LoginResponse)obj;
        if (this.accountName == null ? other.accountName != null : !this.accountName.equals(other.accountName)) {
            return false;
        }
        if (this.accountType == null ? other.accountType != null : !this.accountType.equals((Object)other.accountType)) {
            return false;
        }
        if (this.domainId != other.domainId) {
            return false;
        }
        if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (this.jSessionId == null ? other.jSessionId != null : !this.jSessionId.equals(other.jSessionId)) {
            return false;
        }
        if (this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.registered != other.registered) {
            return false;
        }
        if (this.sessionKey == null ? other.sessionKey != null : !this.sessionKey.equals(other.sessionKey)) {
            return false;
        }
        if (this.timeout != other.timeout) {
            return false;
        }
        if (this.timezone == null ? other.timezone != null : !this.timezone.equals(other.timezone)) {
            return false;
        }
        if (this.timezoneOffset == null ? other.timezoneOffset != null : !this.timezoneOffset.equals(other.timezoneOffset)) {
            return false;
        }
        if (this.userId != other.userId) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountName == null ? 0 : this.accountName.hashCode());
        result = 31 * result + (this.accountType == null ? 0 : this.accountType.hashCode());
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = 31 * result + (this.jSessionId == null ? 0 : this.jSessionId.hashCode());
        result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.registered ? 1231 : 1237);
        result = 31 * result + (this.sessionKey == null ? 0 : this.sessionKey.hashCode());
        result = 31 * result + (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + (this.timezone == null ? 0 : this.timezone.hashCode());
        result = 31 * result + (this.timezoneOffset == null ? 0 : this.timezoneOffset.hashCode());
        result = 31 * result + (int)(this.userId ^ this.userId >>> 32);
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public String toString() {
        return "LoginResponse{username='" + this.username + '\'' + ", userId=" + this.userId + ", password='" + this.password + '\'' + ", domainId=" + this.domainId + ", timeout=" + this.timeout + ", registered=" + this.registered + ", accountName='" + this.accountName + '\'' + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", accountType=" + (Object)((Object)this.accountType) + ", timezone='" + this.timezone + '\'' + ", timezoneOffset='" + this.timezoneOffset + '\'' + ", sessionKey='" + this.sessionKey + '\'' + ", jSessionId='" + this.jSessionId + '\'' + '}';
    }

    @Override
    public int compareTo(LoginResponse arg0) {
        return this.sessionKey.compareTo(arg0.getSessionKey());
    }

    public static class Builder {
        private String username;
        private long userId;
        private String password;
        private long domainId;
        private long timeout;
        private boolean registered;
        private String accountName;
        private String firstName;
        private String lastName;
        private Account.Type accountType;
        private String timezone;
        private String timezoneOffset;
        private String sessionKey;
        private String jSessionId;

        public Builder copyOf(LoginResponse r) {
            this.username = r.username;
            this.userId = r.userId;
            this.password = r.password;
            this.domainId = r.domainId;
            this.timeout = r.timeout;
            this.registered = r.registered;
            this.accountName = r.accountName;
            this.firstName = r.firstName;
            this.lastName = r.lastName;
            this.accountType = r.accountType;
            this.timezone = r.timezone;
            this.timezoneOffset = r.timezoneOffset;
            this.sessionKey = r.sessionKey;
            this.jSessionId = r.jSessionId;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder userId(long userId) {
            this.userId = userId;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder registered(boolean registered) {
            this.registered = registered;
            return this;
        }

        public Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder accountType(Account.Type accountType) {
            this.accountType = accountType;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder timezoneOffset(String timezoneOffset) {
            this.timezoneOffset = timezoneOffset;
            return this;
        }

        public Builder sessionKey(String sessionKey) {
            this.sessionKey = sessionKey;
            return this;
        }

        public Builder jSessionId(String jSessionId) {
            this.jSessionId = jSessionId;
            return this;
        }

        public LoginResponse build() {
            return new LoginResponse(this.username, this.userId, this.password, this.domainId, this.timeout, this.registered, this.accountName, this.firstName, this.lastName, this.accountType, this.timezone, this.timezoneOffset, this.sessionKey, this.jSessionId);
        }
    }
}

