/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.GuestIPType;
import org.jclouds.cloudstack.domain.NetworkOfferingAvailabilityType;
import org.jclouds.cloudstack.domain.TrafficType;

public class NetworkOffering
implements Comparable<NetworkOffering> {
    private long id;
    private String name;
    @SerializedName(value="displaytext")
    private String displayText;
    private Date created;
    @SerializedName(value="availability")
    private NetworkOfferingAvailabilityType availability;
    @SerializedName(value="maxconnections")
    private Integer maxConnections;
    @SerializedName(value="isdefault")
    private boolean isDefault;
    @SerializedName(value="specifyvlan")
    private boolean supportsVLAN;
    @SerializedName(value="traffictype")
    private TrafficType trafficType;
    @SerializedName(value="guestiptype")
    private GuestIPType guestIPType;
    @SerializedName(value="networkrate")
    private int networkRate = -1;
    private String tags;

    public static Builder builder() {
        return new Builder();
    }

    public NetworkOffering(long id, String name, String displayText, @Nullable Date created, NetworkOfferingAvailabilityType availability, boolean supportsVLAN, @Nullable Integer maxConnections, boolean isDefault, TrafficType trafficType, GuestIPType guestIPType, int networkRate, Set<String> tags) {
        this.id = id;
        this.name = name;
        this.displayText = displayText;
        this.created = created;
        this.availability = availability;
        this.supportsVLAN = supportsVLAN;
        this.maxConnections = maxConnections;
        this.isDefault = isDefault;
        this.trafficType = trafficType;
        this.guestIPType = guestIPType;
        this.networkRate = networkRate;
        this.tags = tags.size() == 0 ? null : Joiner.on((char)',').join(tags);
    }

    NetworkOffering() {
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    public NetworkOfferingAvailabilityType getAvailability() {
        return this.availability;
    }

    public boolean supportsVLAN() {
        return this.supportsVLAN;
    }

    @Nullable
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public TrafficType getTrafficType() {
        return this.trafficType;
    }

    public GuestIPType getGuestIPType() {
        return this.guestIPType;
    }

    public int getNetworkRate() {
        return this.networkRate;
    }

    public Set<String> getTags() {
        return this.tags != null ? ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)this.tags)) : ImmutableSet.of();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.availability == null ? 0 : this.availability.hashCode());
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + (this.displayText == null ? 0 : this.displayText.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.isDefault ? 1231 : 1237);
        result = 31 * result + (this.maxConnections == null ? 0 : this.maxConnections.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.supportsVLAN ? 1231 : 1237);
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.trafficType == null ? 0 : this.trafficType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkOffering other = (NetworkOffering)obj;
        if (this.availability == null ? other.availability != null : !this.availability.equals((Object)other.availability)) {
            return false;
        }
        if (this.created == null ? other.created != null : !this.created.equals(other.created)) {
            return false;
        }
        if (this.displayText == null ? other.displayText != null : !this.displayText.equals(other.displayText)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.isDefault != other.isDefault) {
            return false;
        }
        if (this.maxConnections == null ? other.maxConnections != null : !this.maxConnections.equals(other.maxConnections)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.supportsVLAN != other.supportsVLAN) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return this.trafficType == other.trafficType;
    }

    public String toString() {
        return "NetworkOffering{id=" + this.id + ", name='" + this.name + '\'' + ", displayText='" + this.displayText + '\'' + ", created=" + this.created + ", availability=" + (Object)((Object)this.availability) + ", maxConnections=" + this.maxConnections + ", isDefault=" + this.isDefault + ", supportsVLAN=" + this.supportsVLAN + ", trafficType=" + (Object)((Object)this.trafficType) + ", guestIPType=" + (Object)((Object)this.guestIPType) + ", networkRate=" + this.networkRate + ", tags='" + this.tags + '\'' + '}';
    }

    @Override
    public int compareTo(NetworkOffering arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public static class Builder {
        private long id;
        private String name;
        private String displayText;
        private Date created;
        private NetworkOfferingAvailabilityType availability;
        private Integer maxConnections;
        private int networkRate;
        private boolean isDefault;
        private boolean supportsVLAN;
        private TrafficType trafficType;
        private GuestIPType guestIPType;
        private Set<String> tags = ImmutableSet.of();

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder availability(NetworkOfferingAvailabilityType availability) {
            this.availability = availability;
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Builder networkRate(int networkRate) {
            this.networkRate = networkRate;
            return this;
        }

        public Builder supportsVLAN(boolean supportsVLAN) {
            this.supportsVLAN = supportsVLAN;
            return this;
        }

        public Builder trafficType(TrafficType trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        public Builder guestIPType(GuestIPType guestIPType) {
            this.guestIPType = guestIPType;
            return this;
        }

        public Builder tags(Set<String> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this;
        }

        public NetworkOffering build() {
            return new NetworkOffering(this.id, this.name, this.displayText, this.created, this.availability, this.supportsVLAN, this.maxConnections, this.isDefault, this.trafficType, this.guestIPType, this.networkRate, this.tags);
        }
    }
}

