/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Set;

public class PortForwardingRule
implements Comparable<PortForwardingRule> {
    private long id;
    @SerializedName(value="ipaddress")
    private String IPAddress;
    @SerializedName(value="ipaddressid")
    private long IPAddressId;
    @SerializedName(value="privateport")
    private int privatePort;
    private Protocol protocol;
    @SerializedName(value="publicport")
    public int publicPort;
    private State state;
    @SerializedName(value="virtualmachinedisplayname")
    private String virtualMachineDisplayName;
    @SerializedName(value="virtualmachineid")
    public long virtualMachineId;
    @SerializedName(value="virtualmachinename")
    private String virtualMachineName;
    @SerializedName(value="cidrlist")
    private Set<String> CIDRs;
    @SerializedName(value="privateendport")
    private int privateEndPort;
    @SerializedName(value="publicendport")
    private int publicEndPort;

    public static Builder builder() {
        return new Builder();
    }

    public PortForwardingRule(long id, String iPAddress, long iPAddressId, int privatePort, Protocol protocol, int publicPort, State state, String virtualMachineDisplayName, long virtualMachineId, String virtualMachineName, Set<String> CIDRs, int privateEndPort, int publicEndPort) {
        this.id = id;
        this.IPAddress = iPAddress;
        this.IPAddressId = iPAddressId;
        this.privatePort = privatePort;
        this.protocol = protocol;
        this.publicPort = publicPort;
        this.state = state;
        this.virtualMachineDisplayName = virtualMachineDisplayName;
        this.virtualMachineId = virtualMachineId;
        this.virtualMachineName = virtualMachineName;
        this.CIDRs = CIDRs;
        this.privateEndPort = privateEndPort;
        this.publicEndPort = publicEndPort;
    }

    @Override
    public int compareTo(PortForwardingRule arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public long getId() {
        return this.id;
    }

    public String getIPAddress() {
        return this.IPAddress;
    }

    public long getIPAddressId() {
        return this.IPAddressId;
    }

    public int getPrivatePort() {
        return this.privatePort;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    public State getState() {
        return this.state;
    }

    public String getVirtualMachineDisplayName() {
        return this.virtualMachineDisplayName;
    }

    public long getVirtualMachineId() {
        return this.virtualMachineId;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public Set<String> getCIDRs() {
        return this.CIDRs;
    }

    public int getPrivateEndPort() {
        return this.privateEndPort;
    }

    public int getPublicEndPort() {
        return this.publicEndPort;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.IPAddress == null ? 0 : this.IPAddress.hashCode());
        result = 31 * result + (int)(this.IPAddressId ^ this.IPAddressId >>> 32);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.privatePort;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + this.publicPort;
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.virtualMachineDisplayName == null ? 0 : this.virtualMachineDisplayName.hashCode());
        result = 31 * result + (int)(this.virtualMachineId ^ this.virtualMachineId >>> 32);
        result = 31 * result + (this.virtualMachineName == null ? 0 : this.virtualMachineName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortForwardingRule other = (PortForwardingRule)obj;
        if (this.IPAddress == null ? other.IPAddress != null : !this.IPAddress.equals(other.IPAddress)) {
            return false;
        }
        if (this.IPAddressId != other.IPAddressId) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.privatePort != other.privatePort) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals((Object)other.protocol)) {
            return false;
        }
        if (this.privatePort != other.privatePort) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals((Object)other.state)) {
            return false;
        }
        if (this.virtualMachineDisplayName == null ? other.virtualMachineDisplayName != null : !this.virtualMachineDisplayName.equals(other.virtualMachineDisplayName)) {
            return false;
        }
        if (this.virtualMachineId != other.virtualMachineId) {
            return false;
        }
        return !(this.virtualMachineName == null ? other.virtualMachineName != null : !this.virtualMachineName.equals(other.virtualMachineName));
    }

    public String toString() {
        return "PortForwardingRule{id=" + this.id + ", IPAddress='" + this.IPAddress + '\'' + ", IPAddressId=" + this.IPAddressId + ", privatePort=" + this.privatePort + ", protocol='" + (Object)((Object)this.protocol) + '\'' + ", publicPort=" + this.publicPort + ", state='" + (Object)((Object)this.state) + '\'' + ", virtualMachineDisplayName='" + this.virtualMachineDisplayName + '\'' + ", virtualMachineId=" + this.virtualMachineId + ", virtualMachineName='" + this.virtualMachineName + '\'' + ", CIDRs=" + this.getCIDRs() + ", privateEndPort=" + this.privateEndPort + ", publicEndPort=" + this.publicEndPort + '}';
    }

    public static class Builder {
        private long id;
        private String IPAddress;
        private long IPAddressId;
        private int privatePort;
        private Protocol protocol;
        public int publicPort;
        private State state;
        private String virtualMachineDisplayName;
        public long virtualMachineId;
        private String virtualMachineName;
        private Set<String> CIDRs = ImmutableSet.of();
        private int privateEndPort;
        private int publicEndPort;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this;
        }

        public Builder IPAddressId(long IPAddressId) {
            this.IPAddressId = IPAddressId;
            return this;
        }

        public Builder privatePort(int privatePort) {
            this.privatePort = privatePort;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder publicPort(int publicPort) {
            this.publicPort = publicPort;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder virtualMachineDisplayName(String virtualMachineDisplayName) {
            this.virtualMachineDisplayName = virtualMachineDisplayName;
            return this;
        }

        public Builder virtualMachineId(long virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this;
        }

        public Builder virtualMachineName(String virtualMachineName) {
            this.virtualMachineName = virtualMachineName;
            return this;
        }

        public Builder CIDRs(Set<String> CIDRs) {
            this.CIDRs = CIDRs;
            return this;
        }

        public Builder privateEndPort(int privateEndPort) {
            this.privateEndPort = privateEndPort;
            return this;
        }

        public Builder publicEndPort(int publicEndPort) {
            this.publicEndPort = publicEndPort;
            return this;
        }

        public PortForwardingRule build() {
            return new PortForwardingRule(this.id, this.IPAddress, this.IPAddressId, this.privatePort, this.protocol, this.publicPort, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.CIDRs, this.privateEndPort, this.publicEndPort);
        }
    }

    public static enum State {
        STAGED,
        ADD,
        ACTIVE,
        DELETEING,
        UNKNOWN;


        public static State fromValue(String value) {
            try {
                return State.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum Protocol {
        TCP,
        UDP,
        ICMP,
        UNKNOWN;


        public static Protocol fromValue(String value) {
            try {
                return Protocol.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

