/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;
import org.jclouds.cloudstack.domain.Snapshot;

public class SnapshotPolicy
implements Comparable<SnapshotPolicy> {
    private long id;
    @SerializedName(value="intervaltype")
    private Snapshot.Interval interval;
    @SerializedName(value="maxsnaps")
    private long numberToRetain;
    private String schedule;
    private String timezone;
    @SerializedName(value="volumeid")
    private long volumeId;

    public static Builder builder() {
        return new Builder();
    }

    public SnapshotPolicy(long id, Snapshot.Interval interval, long numberToRetain, String schedule, String timezone, long volumeId) {
        this.id = id;
        this.interval = interval;
        this.numberToRetain = numberToRetain;
        this.schedule = schedule;
        this.timezone = timezone;
        this.volumeId = volumeId;
    }

    SnapshotPolicy() {
    }

    public long getId() {
        return this.id;
    }

    public Snapshot.Interval getInterval() {
        return this.interval;
    }

    public long getNumberToRetain() {
        return this.numberToRetain;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public long getVolumeId() {
        return this.volumeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotPolicy that = (SnapshotPolicy)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.numberToRetain != that.numberToRetain) {
            return false;
        }
        if (this.volumeId != that.volumeId) {
            return false;
        }
        if (this.interval != that.interval) {
            return false;
        }
        if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) {
            return false;
        }
        return !(this.timezone != null ? !this.timezone.equals(that.timezone) : that.timezone != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
        result = 31 * result + (int)(this.numberToRetain ^ this.numberToRetain >>> 32);
        result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
        result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
        result = 31 * result + (int)(this.volumeId ^ this.volumeId >>> 32);
        return result;
    }

    public String toString() {
        return "SnapshotPolicy{id=" + this.id + ", interval=" + (Object)((Object)this.interval) + ", numberToRetain=" + this.numberToRetain + ", schedule='" + this.schedule + '\'' + ", timezone='" + this.timezone + '\'' + ", volumeId=" + this.volumeId + '}';
    }

    @Override
    public int compareTo(SnapshotPolicy other) {
        return new Long(this.id).compareTo(other.getId());
    }

    public static class Builder {
        private long id;
        private Snapshot.Interval interval;
        private long numberToRetain;
        private String schedule;
        private String timezone;
        private long volumeId;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder interval(Snapshot.Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder numberToRetain(long numberToRetain) {
            this.numberToRetain = numberToRetain;
            return this;
        }

        public Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder volumeId(long volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public SnapshotPolicy build() {
            return new SnapshotPolicy(this.id, this.interval, this.numberToRetain, this.schedule, this.timezone, this.volumeId);
        }
    }
}

