/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jclouds.cloudstack.domain.Account;

public class User
implements Comparable<User> {
    private long id;
    @SerializedName(value="username")
    private String name;
    @SerializedName(value="firstname")
    private String firstName;
    @SerializedName(value="lastname")
    private String lastName;
    private String email;
    private Date created;
    private State state;
    private String account;
    @SerializedName(value="accounttype")
    private Account.Type accountType;
    private String domain;
    @SerializedName(value="domainid")
    private long domainId;
    @SerializedName(value="timezone")
    private String timeZone;
    @SerializedName(value="apikey")
    private String apiKey;
    @SerializedName(value="secretkey")
    private String secretKey;

    public static Builder builder() {
        return new Builder();
    }

    User() {
    }

    public User(long id, String name, String firstname, String lastname, String email, Date created, State state, String account, Account.Type accountType, String domain, long domainId, String timeZone, String apiKey, String secretKey) {
        this.id = id;
        this.name = name;
        this.firstName = firstname;
        this.lastName = lastname;
        this.email = email;
        this.created = created;
        this.state = state;
        this.account = account;
        this.accountType = accountType;
        this.domain = domain;
        this.domainId = domainId;
        this.timeZone = timeZone;
        this.apiKey = apiKey;
        this.secretKey = secretKey;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public Date getCreated() {
        return this.created;
    }

    public State getState() {
        return this.state;
    }

    public String getAccount() {
        return this.account;
    }

    public Account.Type getAccountType() {
        return this.accountType;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    @Override
    public int compareTo(User arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.account == null ? 0 : this.account.hashCode());
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.account == null ? other.account != null : !this.account.equals(other.account)) {
            return false;
        }
        if (this.domainId != other.domainId) {
            return false;
        }
        return this.id == other.id;
    }

    public String toString() {
        return "User{id=" + this.id + ", name='" + this.name + '\'' + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", email='" + this.email + '\'' + ", created=" + this.created + ", state='" + (Object)((Object)this.state) + '\'' + ", account='" + this.account + '\'' + ", accountType=" + (Object)((Object)this.accountType) + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", timeZone='" + this.timeZone + '\'' + ", apiKey='" + this.apiKey + '\'' + ", secretKey='" + this.secretKey + '\'' + '}';
    }

    public static class Builder {
        private long id;
        private String name;
        private String firstName;
        private String lastName;
        private String email;
        private Date created;
        private State state;
        private String account;
        private Account.Type accountType;
        private String domain;
        private long domainId;
        private String timeZone;
        private String apiKey;
        private String secretKey;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder accountType(Account.Type accountType) {
            this.accountType = accountType;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public User build() {
            return new User(this.id, this.name, this.firstName, this.lastName, this.email, this.created, this.state, this.account, this.accountType, this.domain, this.domainId, this.timeZone, this.apiKey, this.secretKey);
        }
    }

    public static enum State {
        ENABLED,
        DISABLED,
        UNKNOWN;


        public static State fromValue(String value) {
            try {
                return State.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

