/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.options.ListZonesOptions;

@Singleton
public class CorrectHypervisorForZone
implements Function<Long, Predicate<Template>> {
    private final Supplier<Map<Long, Set<String>>> hypervisorsSupplier;

    @Inject
    public CorrectHypervisorForZone(CloudStackClient client) {
        this((Supplier<Map<Long, Set<String>>>)Suppliers.ofInstance(new CloudStackClientToZoneToHypervisors().apply((CloudStackClient)Preconditions.checkNotNull((Object)client, (Object)"client"))));
    }

    public CorrectHypervisorForZone(Supplier<Map<Long, Set<String>>> hypervisorsSupplier) {
        this.hypervisorsSupplier = (Supplier)Preconditions.checkNotNull(hypervisorsSupplier, (Object)"hypervisorsSupplier");
    }

    public Predicate<Template> apply(final Long zoneId) {
        Set acceptableHypervisorsInZone;
        try {
            acceptableHypervisorsInZone = (Set)((Map)this.hypervisorsSupplier.get()).get(zoneId);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("unknown zone: " + zoneId);
        }
        if (acceptableHypervisorsInZone.size() == 0) {
            return Predicates.alwaysFalse();
        }
        return new Predicate<Template>(){

            public boolean apply(Template input) {
                return Predicates.in((Collection)acceptableHypervisorsInZone).apply((Object)input.getHypervisor());
            }

            public String toString() {
                return "hypervisorsInZone(" + zoneId + ", " + acceptableHypervisorsInZone + ")";
            }
        };
    }

    private static class CloudStackClientToZoneToHypervisors
    implements Function<CloudStackClient, Map<Long, Set<String>>> {
        private CloudStackClientToZoneToHypervisors() {
        }

        public Map<Long, Set<String>> apply(CloudStackClient client) {
            Preconditions.checkNotNull((Object)client, (Object)"client");
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Zone zone : client.getZoneClient().listZones(new ListZonesOptions[0])) {
                builder.put((Object)zone.getId(), client.getHypervisorClient().listHypervisorsInZone(zone.getId()));
            }
            return builder.build();
        }
    }
}

