/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.ApiKeyPair;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.options.ListAccountsOptions;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.rest.RestContextFactory;

public class ApiKeyPairs {
    private static final String PROVIDER = "cloudstack";

    public static ApiKeyPair loginToEndpointAsUsernameInDomainWithPasswordAndReturnApiKeyPair(URI endpoint, String username, String password, String domain) {
        ComputeServiceContext context = null;
        try {
            context = new ComputeServiceContextFactory(ApiKeyPairs.setupRestProperties()).createContext(PROVIDER, (Iterable)ImmutableSet.of(), ApiKeyPairs.setupProperties(endpoint, username, password, domain));
            CloudStackClient client = (CloudStackClient)CloudStackClient.class.cast(context.getProviderSpecificContext().getApi());
            Set<Account> listOfAccounts = client.getAccountClient().listAccounts(new ListAccountsOptions[0]);
            domain = domain.equals("") || domain.equals("/") ? "ROOT" : domain;
            for (Account account : listOfAccounts) {
                for (User user : account.getUsers()) {
                    if (!user.getName().equals(username) || !user.getDomain().equals(domain)) continue;
                    ApiKeyPair apiKeyPair = ApiKeyPair.builder().apiKey(user.getApiKey()).secretKey(user.getSecretKey()).build();
                    return apiKeyPair;
                }
            }
            throw new NoSuchElementException("Unable to find API keypair for user " + username);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    private static Properties setupRestProperties() {
        return RestContextFactory.getPropertiesFromResource((String)"/rest.properties");
    }

    private static Properties setupProperties(URI endpoint, String username, String password, String domain) {
        Properties overrides = new Properties();
        overrides.put("jclouds.trust-all-certs", "true");
        overrides.put("jclouds.relax-hostname", "true");
        overrides.put("jclouds.cloudstack.credential-type", "passwordCredentials");
        overrides.put("cloudstack.endpoint", ((URI)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint")).toASCIIString());
        overrides.put("cloudstack.identity", String.format("%s/%s", Preconditions.checkNotNull((Object)domain, (Object)"domain"), Preconditions.checkNotNull((Object)username, (Object)"username")));
        overrides.put("cloudstack.credential", Preconditions.checkNotNull((Object)password, (Object)"password"));
        return overrides;
    }
}

