/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.features.ZoneClient;
import org.jclouds.cloudstack.internal.BaseCloudStackRestClientExpectTest;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ZoneClientExpectTest")
public class ZoneClientExpectTest
extends BaseCloudStackRestClientExpectTest<ZoneClient> {
    public void testListZonesWhenResponseIs2xx() {
        ZoneClient client = (ZoneClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listZones"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"8iHCtck0qfxFTqJ8reyAObRf31I%3D"}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listzonesresponse.json"))).build());
        Assert.assertEquals((Set)client.listZones(new ListZonesOptions[0]), (Set)ImmutableSet.of((Object)Zone.builder().id("1").name("San Jose 1").networkType(NetworkType.ADVANCED).securityGroupsEnabled(false).build(), (Object)Zone.builder().id("2").name("Chicago").networkType(NetworkType.ADVANCED).securityGroupsEnabled(true).build()));
    }

    public void testListZonesWhenResponseIs404() {
        ZoneClient client = (ZoneClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listZones&listAll=true&apiKey=identity&signature=8iHCtck0qfxFTqJ8reyAObRf31I%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listZones(new ListZonesOptions[0]), (Set)ImmutableSet.of());
    }

    @Override
    protected ZoneClient clientFrom(CloudStackContext context) {
        return ((CloudStackClient)context.getProviderSpecificContext().getApi()).getZoneClient();
    }
}

