/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.predicates.UserPredicates;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class UserPredicatesTest {
    @Test
    public void testMatchApiKey() {
        Assert.assertTrue((boolean)UserPredicates.apiKeyEquals((String)"random-text").apply((Object)User.builder().id("random-id").apiKey("random-text").build()));
        Assert.assertFalse((boolean)UserPredicates.apiKeyEquals((String)"something-different").apply((Object)User.builder().id("randome-id").apiKey("random-text").build()));
    }

    @DataProvider(name="accountType")
    public Object[][] getAccountTypes() {
        return new Object[][]{{Account.Type.USER, true, false, false}, {Account.Type.DOMAIN_ADMIN, false, true, false}, {Account.Type.ADMIN, false, false, true}, {Account.Type.UNRECOGNIZED, false, false, false}};
    }

    @Test(dataProvider="accountType")
    public void testAccountType(Account.Type type, boolean isUser, boolean isDomainAdmin, boolean isAdmin) {
        User testUser = User.builder().id("someid").accountType(type).build();
        Assert.assertEquals((boolean)UserPredicates.isUserAccount().apply((Object)testUser), (boolean)isUser);
        Assert.assertEquals((boolean)UserPredicates.isDomainAdminAccount().apply((Object)testUser), (boolean)isDomainAdmin);
        Assert.assertEquals((boolean)UserPredicates.isAdminAccount().apply((Object)testUser), (boolean)isAdmin);
    }
}

