/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import org.jclouds.cloudstack.domain.TemplateMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindTemplateMetadataToQueryParams
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof TemplateMetadata), (Object)"this binder is only valid for TemplateMetadata");
        TemplateMetadata metadata = (TemplateMetadata)input;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)"name", (Object)metadata.getName());
        builder.put((Object)"ostypeid", (Object)metadata.getOsTypeId());
        builder.put((Object)"displaytext", (Object)metadata.getDisplayText());
        if (metadata.getSnapshotId() != null) {
            builder.put((Object)"snapshotid", (Object)metadata.getSnapshotId());
        }
        if (metadata.getVolumeId() != null) {
            builder.put((Object)"volumeid", (Object)metadata.getVolumeId());
        }
        if (metadata.getVirtualMachineId() != null) {
            builder.put((Object)"virtualmachineid", (Object)metadata.getVirtualMachineId());
        }
        if (metadata.isPasswordEnabled() != null) {
            builder.put((Object)"passwordenabled", (Object)metadata.isPasswordEnabled().toString());
        }
        return (R)request.toBuilder().replaceQueryParams((Multimap)builder.build()).build();
    }
}

