/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Properties;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.features.AccountClient;
import org.jclouds.cloudstack.internal.BaseCloudStackRestClientExpectTest;
import org.jclouds.cloudstack.options.ListAccountsOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="PasswordAuthenticationExpectTest")
public class PasswordAuthenticationExpectTest
extends BaseCloudStackRestClientExpectTest<CloudStackContext> {
    protected Properties setupProperties() {
        Properties contextProperties = super.setupProperties();
        contextProperties.setProperty("jclouds.cloudstack.credential-type", "passwordCredentials");
        return contextProperties;
    }

    public void testLoginWithPasswordSetsSessionKeyAndCookie() {
        CloudStackContext context = (CloudStackContext)this.requestsSendResponses(this.loginRequest, this.loginResponse, ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listAccounts&listAll=true&sessionkey=" + URLEncoder.encode("uYT4/MNiglgAKiZRQkvV8QP8gn0="))).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"Cookie", (Object)"JSESSIONID=90DD65D13AEAA590ECCA312D150B9F6D").build())).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listaccountsresponse.json"))).build(), this.logoutRequest, this.logoutResponse);
        AccountClient client = ((CloudStackClient)context.getProviderSpecificContext().getApi()).getAccountClient();
        Assert.assertNotNull((Object)client.listAccounts(new ListAccountsOptions[0]));
        context.close();
    }

    @Override
    protected CloudStackContext clientFrom(CloudStackContext context) {
        return context;
    }
}

