/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.cloudstack.compute.functions.TemplateToImage;
import org.jclouds.cloudstack.compute.functions.TemplateToOperatingSystemTest;
import org.jclouds.cloudstack.compute.functions.ZoneToLocationTest;
import org.jclouds.cloudstack.parse.ListTemplatesResponseTest;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.domain.Location;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class TemplateToImageTest {
    static Supplier<Set<? extends Location>> locationSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)ZoneToLocationTest.one, (Object)ZoneToLocationTest.two));
    static TemplateToImage function = new TemplateToImage(new TemplateToImage.FindLocationForTemplate(locationSupplier), (Function)TemplateToOperatingSystemTest.function);
    static Image one = new ImageBuilder().id("2").providerId("2").name("CentOS 5.3(64-bit) no GUI (XenServer)").operatingSystem(TemplateToOperatingSystemTest.one).description("CentOS 5.3(64-bit) no GUI (XenServer)").status(Image.Status.AVAILABLE).build();
    static Image two = new ImageBuilder().id("4").providerId("4").name("CentOS 5.5(64-bit) no GUI (KVM)").operatingSystem(TemplateToOperatingSystemTest.two).description("CentOS 5.5(64-bit) no GUI (KVM)").status(Image.Status.AVAILABLE).build();
    static Image three = new ImageBuilder().id("203").providerId("203").name("Windows 7 KVM").operatingSystem(TemplateToOperatingSystemTest.three).description("Windows 7 KVM").location(ZoneToLocationTest.two).status(Image.Status.AVAILABLE).build();
    static Image four = new ImageBuilder().id("7").providerId("7").name("CentOS 5.3(64-bit) no GUI (vSphere)").operatingSystem(TemplateToOperatingSystemTest.four).description("CentOS 5.3(64-bit) no GUI (vSphere)").status(Image.Status.AVAILABLE).build();
    static Image five = new ImageBuilder().id("241").providerId("241").name("kvmdev4").operatingSystem(TemplateToOperatingSystemTest.five).description("v5.6.28_Dev4").location(ZoneToLocationTest.two).status(Image.Status.AVAILABLE).build();

    @Test
    public void test() {
        ImmutableSet expected = ImmutableSet.of((Object)one, (Object)two, (Object)three, (Object)four, (Object)five);
        Object offerings = new ListTemplatesResponseTest().expected();
        Iterable profiles = Iterables.transform((Iterable)offerings, (Function)function);
        AssertJUnit.assertEquals((String)profiles.toString(), (String)expected.toString());
    }
}

