/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Set;
import org.jclouds.cloudstack.domain.ISO;
import org.jclouds.cloudstack.domain.ISOPermissions;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.ListISOsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ISOClientLiveTest")
public class ISOClientLiveTest
extends BaseCloudStackClientLiveTest {
    public void testListPublicISOs() throws Exception {
        Set response = this.client.getISOClient().listISOs(new ListISOsOptions[]{ListISOsOptions.Builder.isPublic()});
        Assert.assertNotNull((Object)response);
        Assert.assertFalse((boolean)response.isEmpty());
        long isoCount = response.size();
        Assert.assertTrue((isoCount >= 0L ? 1 : 0) != 0);
        for (ISO iso : response) {
            ISO query = this.client.getISOClient().getISO(iso.getId());
            Assert.assertEquals((String)query.getId(), (String)iso.getId());
        }
    }

    public void testListISOPermissions() throws Exception {
        Set response = this.client.getISOClient().listISOs(new ListISOsOptions[]{ListISOsOptions.Builder.isPublic()});
        Assert.assertNotNull((Object)response);
        Assert.assertFalse((boolean)response.isEmpty());
        long isoCount = response.size();
        Assert.assertTrue((isoCount >= 0L ? 1 : 0) != 0);
        for (ISO iso : response) {
            ISOPermissions perms = this.client.getISOClient().listISOPermissions(iso.getId(), new AccountInDomainOptions[0]);
            Assert.assertNotNull((Object)perms);
        }
    }
}

