/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.CloudStackDomainClient;
import org.jclouds.cloudstack.domain.Domain;
import org.jclouds.cloudstack.features.DomainDomainClient;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.ListDomainChildrenOptions;
import org.jclouds.cloudstack.options.ListDomainsOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DomainDomainClientExpectTest")
public class DomainDomainClientExpectTest
extends BaseCloudStackExpectTest<DomainDomainClient> {
    public void testListDomainsWhenResponseIs2xx() {
        DomainDomainClient client = (DomainDomainClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listDomains&listAll=true&apiKey=identity&signature=sVFaGTu0DNSTVtWy3wtRt7KTx0w%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listdomainsresponse.json"))).build());
        Assert.assertEquals((Set)client.listDomains(new ListDomainsOptions[0]), (Set)ImmutableSet.of((Object)Domain.builder().id("1").name("ROOT").level(0L).hasChild(true).build(), (Object)Domain.builder().id("2").name("jclouds1").level(1L).parentDomainId("1").parentDomainName("ROOT").hasChild(false).build()));
    }

    public void testListDomainsWhenResponseIs404() {
        DomainDomainClient client = (DomainDomainClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listDomains&listAll=true&apiKey=identity&signature=sVFaGTu0DNSTVtWy3wtRt7KTx0w%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listDomains(new ListDomainsOptions[0]), (Set)ImmutableSet.of());
    }

    public void testGetDomainWhenResponseIs2xx() {
        DomainDomainClient client = (DomainDomainClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listDomains&listAll=true&id=1&apiKey=identity&signature=M16YxHWKST/cIRUHvWhfWovJugU%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getdomainresponse.json"))).build());
        Assert.assertEquals((Object)client.getDomainById("1"), (Object)Domain.builder().id("1").name("ROOT").level(0L).hasChild(true).build());
    }

    public void testGetDomainWhenResponseIs404() {
        DomainDomainClient client = (DomainDomainClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listDomains&listAll=true&id=1&apiKey=identity&signature=M16YxHWKST/cIRUHvWhfWovJugU%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.getDomainById("1"));
    }

    public void testListDomainChildrenWhenResponseIs2xx() {
        DomainDomainClient client = (DomainDomainClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listDomainChildren&listAll=true&id=1&isrecursive=true&apiKey=identity&signature=Jn6kFkloRvfaaivlJiHd0F5J3Jk%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listdomainchildrenresponse.json"))).build());
        Assert.assertEquals((Set)client.listDomainChildren(new ListDomainChildrenOptions[]{ListDomainChildrenOptions.Builder.parentDomainId((String)"1").isRecursive(true)}), (Set)ImmutableSet.of((Object)Domain.builder().id("2").name("jclouds1").level(1L).parentDomainId("1").parentDomainName("ROOT").hasChild(false).build(), (Object)Domain.builder().id("3").name("jclouds2").level(1L).parentDomainId("1").parentDomainName("ROOT").hasChild(false).build()));
    }

    public void testListDomainChildrenWhenResponseIs404() {
        DomainDomainClient client = (DomainDomainClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listDomainChildren&listAll=true&id=1&isrecursive=true&apiKey=identity&signature=Jn6kFkloRvfaaivlJiHd0F5J3Jk%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listDomainChildren(new ListDomainChildrenOptions[]{ListDomainChildrenOptions.Builder.parentDomainId((String)"1").isRecursive(true)}), (Set)ImmutableSet.of());
    }

    @Override
    protected DomainDomainClient clientFrom(CloudStackContext context) {
        return ((CloudStackDomainClient)context.getDomainContext().getApi()).getDomainClient();
    }
}

