/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.CloudStackGlobalClient;
import org.jclouds.cloudstack.domain.ConfigurationEntry;
import org.jclouds.cloudstack.features.GlobalConfigurationClient;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.ListConfigurationEntriesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalConfigurationClientExpectTest")
public class GlobalConfigurationClientExpectTest
extends BaseCloudStackExpectTest<GlobalConfigurationClient> {
    @Test
    public void testListConfigurationEntriesWhenResponseIs2xx() {
        GlobalConfigurationClient client = (GlobalConfigurationClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listConfigurations&listAll=true&apiKey=identity&signature=%2BJ9mTuw%2BZXaumzMAJAXgZQaO2cc%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listconfigurationsresponse.json"))).build());
        Assert.assertEquals((Set)client.listConfigurationEntries(new ListConfigurationEntriesOptions[0]), (Set)ImmutableSet.of((Object)ConfigurationEntry.builder().category("Advanced").name("account.cleanup.interval").value("86400").description("The interval (in seconds) between cleanup for removed accounts").build(), (Object)ConfigurationEntry.builder().category("Advanced").name("agent.lb.enabled").value("true").description("If agent load balancing enabled in cluster setup").build()));
    }

    @Test
    public void testListConfigurationEntriesEmptyOn404() {
        GlobalConfigurationClient client = (GlobalConfigurationClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listConfigurations&listAll=true&apiKey=identity&signature=%2BJ9mTuw%2BZXaumzMAJAXgZQaO2cc%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listConfigurationEntries(new ListConfigurationEntriesOptions[0]), (Set)ImmutableSet.of());
    }

    @Test
    public void testUpdateConfigurationEntryWhenResponseIs2xx() {
        GlobalConfigurationClient client = (GlobalConfigurationClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=updateConfiguration&name=expunge.delay&value=11&apiKey=identity&signature=I2yG35EhfgIXYObeLfU3cvf%2BPeE%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/updateconfigurationsresponse.json"))).build());
        Assert.assertEquals((Object)client.updateConfigurationEntry("expunge.delay", "11"), (Object)ConfigurationEntry.builder().category("Advanced").name("expunge.delay").value("11").description("Determines how long (in seconds) to wait before actually expunging destroyed vm. The default value = the default value of expunge.interval").build());
    }

    @Test
    public void testUpdateConfigurationEntryNullOn404() {
        GlobalConfigurationClient client = (GlobalConfigurationClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=updateConfiguration&name=expunge.delay&value=11&apiKey=identity&signature=I2yG35EhfgIXYObeLfU3cvf%2BPeE%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.updateConfigurationEntry("expunge.delay", "11"));
    }

    @Override
    protected GlobalConfigurationClient clientFrom(CloudStackContext context) {
        return ((CloudStackGlobalClient)context.getGlobalContext().getApi()).getConfigurationClient();
    }
}

