/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.domain.LoadBalancerRule;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.features.VirtualMachineClientLiveTest;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.CreateLoadBalancerRuleOptions;
import org.jclouds.cloudstack.options.ListLoadBalancerRulesOptions;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.jclouds.cloudstack.predicates.LoadBalancerRuleActive;
import org.jclouds.cloudstack.predicates.NetworkPredicates;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.ssh.SshException;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="LoadBalancerClientLiveTest")
public class LoadBalancerClientLiveTest
extends BaseCloudStackClientLiveTest {
    private PublicIPAddress ip = null;
    private VirtualMachine vm;
    private LoadBalancerRule rule;
    private RetryablePredicate<LoadBalancerRule> loadBalancerRuleActive;
    private Network network;
    private boolean networksDisabled;

    @Override
    @BeforeGroups(groups={"live"})
    public void setupContext() {
        super.setupContext();
        this.loadBalancerRuleActive = new RetryablePredicate((Predicate)new LoadBalancerRuleActive(this.client), 60L, 1L, 1L, TimeUnit.SECONDS);
        this.prefix = this.prefix + "rule";
        try {
            this.network = (Network)Iterables.find((Iterable)this.client.getNetworkClient().listNetworks(new ListNetworksOptions[0]), (Predicate)Predicates.and((Predicate[])new Predicate[]{NetworkPredicates.hasLoadBalancerService(), NetworkPredicates.isVirtualNetwork(), new Predicate<Network>(){

                public boolean apply(Network network) {
                    return network.isDefault() && !network.isSecurityGroupEnabled() && !network.isSystem() && network.getAccount().equals(LoadBalancerClientLiveTest.this.user.getName());
                }
            }}));
        }
        catch (NoSuchElementException e) {
            this.networksDisabled = true;
        }
    }

    public void testCreateVm() {
        if (this.networksDisabled) {
            return;
        }
        String defaultTemplate = this.template != null ? this.template.getImageId() : null;
        this.vm = VirtualMachineClientLiveTest.createVirtualMachineInNetwork(this.network, LoadBalancerClientLiveTest.defaultTemplateOrPreferredInZone(defaultTemplate, this.client, this.network.getZoneId()), this.client, (RetryablePredicate<String>)this.jobComplete, (RetryablePredicate<VirtualMachine>)this.virtualMachineRunning);
        if (this.vm.getPassword() != null && !this.loginCredentials.hasPasswordOption()) {
            this.loginCredentials = this.loginCredentials.toBuilder().password(this.vm.getPassword()).build();
        }
    }

    @Test(dependsOnMethods={"testCreateVm"})
    public void testCreateLoadBalancerRule() throws Exception {
        if (this.networksDisabled) {
            return;
        }
        int attempts = 0;
        while (this.rule == null && attempts < 10) {
            this.ip = this.reuseOrAssociate.apply(this.network);
            try {
                LoadBalancerRule result;
                String jobId = this.client.getLoadBalancerClient().createLoadBalancerRuleForPublicIP(this.ip.getId(), LoadBalancerRule.Algorithm.LEASTCONN, this.prefix, 22, 22, new CreateLoadBalancerRuleOptions[0]);
                Assert.assertTrue((boolean)this.jobComplete.apply((Object)jobId));
                AsyncJob asyncJob = this.client.getAsyncJobClient().getAsyncJob(jobId);
                this.rule = result = (LoadBalancerRule)asyncJob.getResult();
            }
            catch (IllegalStateException e) {
                ++attempts;
            }
        }
        Assert.assertNotNull((Object)this.rule, (String)("Failed to get a load balancer rule after " + attempts + " attempts"));
        assert (this.rule.getPublicIPId() == this.ip.getId()) : this.rule;
        Assert.assertEquals((int)this.rule.getPublicPort(), (int)22);
        Assert.assertEquals((int)this.rule.getPrivatePort(), (int)22);
        Assert.assertEquals((Object)this.rule.getAlgorithm(), (Object)LoadBalancerRule.Algorithm.LEASTCONN);
        Assert.assertEquals((String)this.rule.getName(), (String)this.prefix);
        Assert.assertEquals((Object)this.rule.getState(), (Object)LoadBalancerRule.State.ADD);
        Assert.assertEquals((int)this.client.getLoadBalancerClient().listVirtualMachinesAssignedToLoadBalancerRule(this.rule.getId()).size(), (int)0);
        this.checkRule(this.rule);
    }

    @Test(dependsOnMethods={"testCreateLoadBalancerRule"})
    public void testAssignToLoadBalancerRule() throws Exception {
        if (this.networksDisabled) {
            return;
        }
        String jobId = this.client.getLoadBalancerClient().assignVirtualMachinesToLoadBalancerRule(this.rule.getId(), new String[]{this.vm.getId()});
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)jobId));
        AsyncJob result = this.client.getAsyncJobClient().getAsyncJob(jobId);
        Assert.assertTrue((boolean)result.hasSucceed());
        Set machines = this.client.getLoadBalancerClient().listVirtualMachinesAssignedToLoadBalancerRule(this.rule.getId());
        Assert.assertEquals((int)machines.size(), (int)1);
        Assert.assertTrue((boolean)this.loadBalancerRuleActive.apply((Object)this.rule), (String)this.rule.toString());
    }

    @Test(dependsOnMethods={"testAssignToLoadBalancerRule"})
    public void testCanSshInThroughNewLoadBalancerRule() throws Exception {
        this.loopAndCheckSSH();
    }

    private void loopAndCheckSSH() throws IOException {
        for (int i = 0; i < 5; ++i) {
            try {
                this.checkSSH(HostAndPort.fromParts((String)this.ip.getIPAddress(), (int)22));
                return;
            }
            catch (SshException e) {
                e.printStackTrace();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    @Test(dependsOnMethods={"testAssignToLoadBalancerRule"}, expectedExceptions={SshException.class})
    public void testRemoveFromLoadBalancerRule() throws Exception {
        if (this.networksDisabled) {
            throw new SshException();
        }
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getLoadBalancerClient().removeVirtualMachinesFromLoadBalancerRule(this.rule.getId(), new String[]{this.vm.getId()})));
        Assert.assertEquals((int)this.client.getLoadBalancerClient().listVirtualMachinesAssignedToLoadBalancerRule(this.rule.getId()).size(), (int)0);
        Assert.assertEquals((Object)this.rule.getState(), (Object)LoadBalancerRule.State.ADD);
        this.checkSSH(HostAndPort.fromParts((String)this.ip.getIPAddress(), (int)22));
    }

    @AfterGroups(groups={"live"})
    protected void tearDownContext() {
        if (this.rule != null) {
            Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getLoadBalancerClient().deleteLoadBalancerRule(this.rule.getId())));
        }
        if (this.vm != null) {
            Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getVirtualMachineClient().destroyVirtualMachine(this.vm.getId())));
        }
        if (this.ip != null) {
            this.client.getAddressClient().disassociateIPAddress(this.ip.getId());
        }
        super.tearDownContext();
    }

    public void testListLoadBalancerRules() throws Exception {
        Set response = this.client.getLoadBalancerClient().listLoadBalancerRules(new ListLoadBalancerRulesOptions[0]);
        assert (null != response);
        Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
        for (LoadBalancerRule rule : response) {
            LoadBalancerRule newDetails = this.findRuleWithId(rule.getId());
            Assert.assertEquals((String)rule.getId(), (String)newDetails.getId());
            this.checkRule(rule);
        }
    }

    private LoadBalancerRule findRuleWithId(final String id) {
        return (LoadBalancerRule)Iterables.find((Iterable)this.client.getLoadBalancerClient().listLoadBalancerRules(new ListLoadBalancerRulesOptions[0]), (Predicate)new Predicate<LoadBalancerRule>(){

            public boolean apply(LoadBalancerRule arg0) {
                return arg0.getId() == id;
            }
        });
    }

    protected void checkRule(LoadBalancerRule rule) {
        Assert.assertEquals((String)rule.getId(), (String)this.findRuleWithId(rule.getId()).getId());
        assert (rule.getId() != null) : rule;
        assert (rule.getAccount() != null) : rule;
        assert (rule.getAlgorithm() != null) : rule;
        assert (rule.getPrivatePort() > 0) : rule;
        assert (rule.getPublicPort() > 0) : rule;
        assert (rule.getDomain() != null) : rule;
        assert (rule.getDomainId() != null) : rule;
        assert (rule.getState() != null) : rule;
        assert (rule.getName() != null) : rule;
        assert (rule.getPublicIP() != null) : rule;
        assert (rule.getPublicIPId() != null) : rule;
    }
}

