/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jclouds.cloudstack.domain.ExtractMode;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.TemplateFilter;
import org.jclouds.cloudstack.domain.TemplateMetadata;
import org.jclouds.cloudstack.features.TemplateAsyncClient;
import org.jclouds.cloudstack.internal.BaseCloudStackAsyncClientTest;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.CreateTemplateOptions;
import org.jclouds.cloudstack.options.DeleteTemplateOptions;
import org.jclouds.cloudstack.options.ExtractTemplateOptions;
import org.jclouds.cloudstack.options.ListTemplatesOptions;
import org.jclouds.cloudstack.options.RegisterTemplateOptions;
import org.jclouds.cloudstack.options.UpdateTemplateOptions;
import org.jclouds.cloudstack.options.UpdateTemplatePermissionsOptions;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.rest.functions.MapHttp4xxCodesToExceptions;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TemplateAsyncClientTest")
public class TemplateAsyncClientTest
extends BaseCloudStackAsyncClientTest<TemplateAsyncClient> {
    HttpRequest registerTemplate = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"registerTemplate"}).addQueryParam("format", new String[]{"QCOW2"}).addQueryParam("hypervisor", new String[]{"xen"}).addQueryParam("url", new String[]{"http%3A//example.com/"}).addQueryParam("zoneid", new String[]{"20"}).addQueryParam("name", new String[]{"thename"}).addQueryParam("ostypeid", new String[]{"10"}).addQueryParam("displaytext", new String[]{"description"}).build();
    HttpRequest registerTemplateOptions = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"registerTemplate"}).addQueryParam("format", new String[]{"QCOW2"}).addQueryParam("hypervisor", new String[]{"xen"}).addQueryParam("url", new String[]{"http%3A//example.com/"}).addQueryParam("zoneid", new String[]{"20"}).addQueryParam("account", new String[]{"mydomain"}).addQueryParam("domainid", new String[]{"3"}).addQueryParam("bits", new String[]{"32"}).addQueryParam("checksum", new String[]{"ABC"}).addQueryParam("isextractable", new String[]{"true"}).addQueryParam("isfeatured", new String[]{"true"}).addQueryParam("ispublic", new String[]{"true"}).addQueryParam("passwordenabled", new String[]{"true"}).addQueryParam("requireshvm", new String[]{"true"}).addQueryParam("name", new String[]{"thename"}).addQueryParam("ostypeid", new String[]{"10"}).addQueryParam("displaytext", new String[]{"description"}).build();
    HttpRequest copyTemplate = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"copyTemplate"}).addQueryParam("id", new String[]{"17"}).addQueryParam("sourcezoneid", new String[]{"18"}).addQueryParam("destzoneid", new String[]{"19"}).build();
    HttpRequest extractTemplate = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"extractTemplate"}).addQueryParam("id", new String[]{"3"}).addQueryParam("mode", new String[]{"HTTP_DOWNLOAD"}).addQueryParam("zoneid", new String[]{"5"}).build();
    HttpRequest extractTemplateOptions = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"extractTemplate"}).addQueryParam("id", new String[]{"3"}).addQueryParam("mode", new String[]{"HTTP_DOWNLOAD"}).addQueryParam("zoneid", new String[]{"5"}).addQueryParam("url", new String[]{"http%3A//example.com/"}).build();

    public void testCreateTemplate() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("createTemplate", TemplateMetadata.class, CreateTemplateOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{TemplateMetadata.builder().name("thename").osTypeId("10").displayText("description").build()});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=createTemplate&name=thename&ostypeid=10&displaytext=description HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateTemplateOptions() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("createTemplate", TemplateMetadata.class, CreateTemplateOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{TemplateMetadata.builder().name("thename").osTypeId("10").displayText("description").build(), CreateTemplateOptions.Builder.bits((int)32).isFeatured(true).isPublic(true).passwordEnabled(true).requiresHVM(true).snapshotId("11").volumeId("12")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=createTemplate&bits=32&isfeatured=true&ispublic=true&passwordenabled=true&requireshvm=true&snapshotid=11&volumeid=12&name=thename&ostypeid=10&displaytext=description HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testRegisterTemplate() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("registerTemplate", TemplateMetadata.class, String.class, String.class, String.class, String.class, RegisterTemplateOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{TemplateMetadata.builder().name("thename").osTypeId("10").displayText("description").build(), Template.Format.QCOW2, "xen", "http://example.com/", 20});
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.registerTemplate.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testRegisterTemplateOptions() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("registerTemplate", TemplateMetadata.class, String.class, String.class, String.class, String.class, RegisterTemplateOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{TemplateMetadata.builder().name("thename").osTypeId("10").displayText("description").build(), Template.Format.QCOW2, "xen", "http://example.com/", 20, RegisterTemplateOptions.Builder.accountInDomain((String)"mydomain", (String)"3").bits(32).checksum("ABC").isExtractable(true).isFeatured(true).isPublic(true).passwordEnabled(true).requiresHVM(true)});
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.registerTemplateOptions.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testUpdateTemplate() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("updateTemplate", String.class, UpdateTemplateOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{17});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=updateTemplate&id=17 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testUpdateTemplateOptions() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("updateTemplate", String.class, UpdateTemplateOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{17, UpdateTemplateOptions.Builder.bootable((boolean)true).displayText("description").format(Template.Format.VHD).name("thename").osTypeId("12").passwordEnabled(true)});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=updateTemplate&id=17&bootable=true&displaytext=description&format=VHD&name=thename&ostypeid=12&passwordenabled=true HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCopyTemplate() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("copyTemplateToZone", String.class, String.class, String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{17, 18, 19});
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.copyTemplate.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteTemplate() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("deleteTemplate", String.class, DeleteTemplateOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{17});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=deleteTemplate&id=17 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteTemplateOptions() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("deleteTemplate", String.class, DeleteTemplateOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{17, DeleteTemplateOptions.Builder.zoneId((String)"8")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=deleteTemplate&id=17&zoneid=8 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListTemplates() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TemplateAsyncClient.class.getMethod("listTemplates", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listTemplates&listAll=true&templatefilter=executable HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListTemplatesOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TemplateAsyncClient.class.getMethod("listTemplates", ListTemplatesOptions.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{ListTemplatesOptions.Builder.accountInDomain((String)"adrian", (String)"6").hypervisor("xen").filter(TemplateFilter.FEATURED)});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listTemplates&listAll=true&account=adrian&domainid=6&hypervisor=xen&templatefilter=featured HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetTemplate() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TemplateAsyncClient.class.getMethod("getTemplateInZone", String.class, String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{5, 1});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listTemplates&listAll=true&templatefilter=executable&id=5&zoneid=1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, Functions.compose((Function)IdentityFunction.INSTANCE, (Function)IdentityFunction.INSTANCE).getClass());
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testUpdateTemplatePermissions() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("updateTemplatePermissions", String.class, UpdateTemplatePermissionsOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{17});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=updateTemplatePermissions&id=17 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testUpdateTemplatePermissionsOptions() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("updateTemplatePermissions", String.class, UpdateTemplatePermissionsOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{17, UpdateTemplatePermissionsOptions.Builder.accounts((Iterable)ImmutableSet.of((Object)"5", (Object)"6")).isExtractable(true).isFeatured(true).isPublic(true).op(UpdateTemplatePermissionsOptions.Operation.add)});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=updateTemplatePermissions&id=17&accounts=5,6&isextractable=true&isfeatured=true&ispublic=true&op=add HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListTemplatePermissions() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("listTemplatePermissions", String.class, AccountInDomainOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{17});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listTemplatePermissions&listAll=true&id=17 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListTemplatePermissionsOptions() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("listTemplatePermissions", String.class, AccountInDomainOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{17, AccountInDomainOptions.Builder.accountInDomain((String)"fred", (String)"8")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listTemplatePermissions&listAll=true&id=17&account=fred&domainid=8 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testExtractTemplate() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("extractTemplate", String.class, ExtractMode.class, String.class, ExtractTemplateOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{3, ExtractMode.HTTP_DOWNLOAD, 5});
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.extractTemplate.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testExtractTemplateOptions() throws NoSuchMethodException {
        Method method = TemplateAsyncClient.class.getMethod("extractTemplate", String.class, ExtractMode.class, String.class, ExtractTemplateOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{3, ExtractMode.HTTP_DOWNLOAD, 5, ExtractTemplateOptions.Builder.url((String)"http://example.com/")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.extractTemplateOptions.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected TypeLiteral<RestAnnotationProcessor<TemplateAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<TemplateAsyncClient>>(){};
    }
}

