/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.Pod;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreatePodOptions;
import org.jclouds.cloudstack.options.ListPodsOptions;
import org.jclouds.cloudstack.options.UpdatePodOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GlobalPodAsyncClient {
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listPods", "true"})
    @SelectJson(value={"pod"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Pod>> listPods(ListPodsOptions ... var1);

    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listPods", "true"})
    @SelectJson(value={"pod"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Pod> getPod(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"createPod"})
    @SelectJson(value={"pod"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Pod> createPod(@QueryParam(value="name") String var1, @QueryParam(value="zoneid") String var2, @QueryParam(value="startip") String var3, @QueryParam(value="endip") String var4, @QueryParam(value="gateway") String var5, @QueryParam(value="netmask") String var6, CreatePodOptions ... var7);

    @GET
    @QueryParams(keys={"command"}, values={"createPod"})
    @SelectJson(value={"pod"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Pod> createPod(@QueryParam(value="name") String var1, @QueryParam(value="zoneid") String var2, @QueryParam(value="startip") String var3, @QueryParam(value="gateway") String var4, @QueryParam(value="netmask") String var5, CreatePodOptions ... var6);

    @GET
    @QueryParams(keys={"command"}, values={"deletePod"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deletePod(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"updatePod"})
    @SelectJson(value={"pod"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Pod> updatePod(@QueryParam(value="id") String var1, UpdatePodOptions ... var2);
}

