/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.inject.TypeLiteral;
import java.lang.reflect.Method;
import org.jclouds.cloudstack.features.DomainAccountAsyncClient;
import org.jclouds.cloudstack.internal.BaseCloudStackAsyncClientTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DomainAccountAsyncClientTest")
public class DomainAccountAsyncClientTest
extends BaseCloudStackAsyncClientTest<DomainAccountAsyncClient> {
    public void testEnableAccount() throws Exception {
        Method method = DomainAccountAsyncClient.class.getMethod("enableAccount", String.class, String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"goo", "2"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=enableAccount&account=goo&domainid=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDisableAccount() throws Exception {
        Method method = DomainAccountAsyncClient.class.getMethod("disableAccount", String.class, String.class, Boolean.TYPE);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"1", "2", true});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=disableAccount&account=1&lock=true&domainid=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected TypeLiteral<RestAnnotationProcessor<DomainAccountAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<DomainAccountAsyncClient>>(){};
    }
}

