/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jclouds.cloudstack.features.GlobalAlertAsyncClient;
import org.jclouds.cloudstack.internal.BaseCloudStackAsyncClientTest;
import org.jclouds.cloudstack.options.ListAlertsOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalAlertAsyncClientTest")
public class GlobalAlertAsyncClientTest
extends BaseCloudStackAsyncClientTest<GlobalAlertAsyncClient> {
    public void testListAlerts() throws SecurityException, NoSuchMethodException, IOException {
        Method method = GlobalAlertAsyncClient.class.getMethod("listAlerts", ListAlertsOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listAlerts&listAll=true HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListAlertsOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = GlobalAlertAsyncClient.class.getMethod("listAlerts", ListAlertsOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{ListAlertsOptions.Builder.id((String)"42").keyword("jclouds").type("TEMPLATE")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listAlerts&listAll=true&id=42&keyword=jclouds&type=TEMPLATE HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected TypeLiteral<RestAnnotationProcessor<GlobalAlertAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<GlobalAlertAsyncClient>>(){};
    }
}

