/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkOffering;
import org.jclouds.cloudstack.domain.TrafficType;
import org.jclouds.cloudstack.domain.VlanIPRange;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.CreateNetworkOptions;
import org.jclouds.cloudstack.options.CreateVlanIPRangeOptions;
import org.jclouds.cloudstack.options.ListNetworkOfferingsOptions;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.jclouds.cloudstack.options.ListVlanIPRangesOptions;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.cloudstack.predicates.NetworkOfferingPredicates;
import org.jclouds.cloudstack.predicates.ZonePredicates;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalVlanClientLiveTest")
public class GlobalVlanClientLiveTest
extends BaseCloudStackClientLiveTest {
    private Network network;
    private boolean usingExistingNetwork;
    private VlanIPRange range;

    @Test
    public void testListVlanIPRanges() throws Exception {
        this.skipIfNotGlobalAdmin();
        Set response = this.globalAdminClient.getVlanClient().listVlanIPRanges(new ListVlanIPRangesOptions[0]);
        assert (null != response);
        long rangeCount = response.size();
        Assert.assertTrue((rangeCount >= 0L ? 1 : 0) != 0);
        for (VlanIPRange range : response) {
            VlanIPRange newDetails = (VlanIPRange)Iterables.getOnlyElement((Iterable)this.globalAdminClient.getVlanClient().listVlanIPRanges(new ListVlanIPRangesOptions[]{ListVlanIPRangesOptions.Builder.id((String)range.getId())}));
            Assert.assertEquals((Object)range, (Object)newDetails);
            Assert.assertEquals((Object)range, (Object)this.globalAdminClient.getVlanClient().getVlanIPRange(range.getId()));
            Assert.assertFalse((range.getId() != null ? 1 : 0) != 0);
            Assert.assertFalse((range.getZoneId() != null ? 1 : 0) != 0);
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)range.getVlan()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)range.getAccount()));
            Assert.assertFalse((range.getDomainId() != null ? 1 : 0) != 0);
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)range.getDomain()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)range.getGateway()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)range.getNetmask()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)range.getStartIP()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)range.getEndIP()));
            Assert.assertFalse((range.getNetworkId() != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCreateVlanIPRange() {
        this.skipIfNotGlobalAdmin();
        Zone zone = (Zone)Iterables.find((Iterable)this.client.getZoneClient().listZones(new ListZonesOptions[0]), (Predicate)ZonePredicates.supportsAdvancedNetworks());
        final NetworkOffering offering = (NetworkOffering)Iterables.find((Iterable)this.client.getOfferingClient().listNetworkOfferings(new ListNetworkOfferingsOptions[0]), (Predicate)NetworkOfferingPredicates.supportsGuestVirtualNetworks());
        Set suitableNetworks = Sets.filter((Set)this.client.getNetworkClient().listNetworks(new ListNetworksOptions[]{ListNetworksOptions.Builder.zoneId((String)zone.getId()).isSystem(false).trafficType(TrafficType.GUEST)}), (Predicate)new Predicate<Network>(){

            public boolean apply(Network network) {
                return network.getNetworkOfferingId().equals(offering.getId());
            }
        });
        if (suitableNetworks.size() > 0) {
            this.network = (Network)Iterables.get((Iterable)suitableNetworks, (int)0);
            this.usingExistingNetwork = true;
        } else if (this.network == null) {
            this.network = this.client.getNetworkClient().createNetworkInZone(zone.getId(), offering.getId(), "net-" + this.prefix, "jclouds test " + this.prefix, new CreateNetworkOptions[0]);
            this.usingExistingNetwork = false;
        }
        this.range = this.globalAdminClient.getVlanClient().createVlanIPRange("172.19.1.1", "172.19.1.199", new CreateVlanIPRangeOptions[]{CreateVlanIPRangeOptions.Builder.accountInDomain((String)this.user.getAccount(), (String)this.user.getDomainId()).forVirtualNetwork(true).vlan(1001L).networkId(this.network.getId())});
    }

    @AfterClass
    public void testFixtureTearDown() {
        if (this.range != null) {
            this.globalAdminClient.getVlanClient().deleteVlanIPRange(this.range.getId());
            this.range = null;
        }
        if (this.network != null && !this.usingExistingNetwork) {
            this.client.getNetworkClient().deleteNetwork(this.network.getId());
            this.network = null;
        }
    }
}

