/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ZoneClientLiveTest")
public class ZoneClientLiveTest
extends BaseCloudStackClientLiveTest {
    public void testListZones() throws Exception {
        Set response = this.client.getZoneClient().listZones(new ListZonesOptions[0]);
        assert (null != response);
        long zoneCount = response.size();
        Assert.assertTrue((zoneCount >= 0L ? 1 : 0) != 0);
        for (Zone zone : response) {
            Zone newDetails = (Zone)Iterables.getOnlyElement((Iterable)this.client.getZoneClient().listZones(new ListZonesOptions[]{ListZonesOptions.Builder.id((String)zone.getId())}));
            Assert.assertEquals((Object)zone, (Object)newDetails);
            Assert.assertEquals((Object)zone, (Object)this.client.getZoneClient().getZone(zone.getId()));
            assert (zone.getId() != null) : zone;
            assert (zone.getName() != null) : zone;
            assert (zone.getNetworkType() != null && zone.getNetworkType() != NetworkType.UNRECOGNIZED) : zone;
            switch (zone.getNetworkType()) {
                case ADVANCED: {
                    break;
                }
                case BASIC: {
                    assert (zone.getVLAN() == null) : zone;
                    assert (zone.getDNS().size() >= 0) : zone;
                    assert (zone.getInternalDNS().size() >= 0) : zone;
                    assert (zone.getDomain() == null) : zone;
                    assert (zone.getDomainId() == null) : zone;
                    assert (zone.getGuestCIDRAddress() == null) : zone;
                    break;
                }
            }
        }
    }
}

