/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.handlers;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.cloudstack.handlers.CloudStackErrorHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CloudStackErrorHandlerTest {
    @Test
    public void test400MakesIllegalArgumentException() {
        this.assertCodeMakes("GET", URI.create("https://cloudstack.com/foo"), 400, "", "Bad Request", IllegalArgumentException.class);
    }

    @Test
    public void test401MakesAuthorizationException() {
        this.assertCodeMakes("GET", URI.create("https://cloudstack.com/foo"), 401, "", "Unauthorized", AuthorizationException.class);
    }

    @Test
    public void test404MakesResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://cloudstack.com/foo"), 404, "", "Not Found", ResourceNotFoundException.class);
    }

    @Test
    public void test405MakesIllegalArgumentException() {
        this.assertCodeMakes("GET", URI.create("https://cloudstack.com/foo"), 405, "", "Method Not Allowed", IllegalArgumentException.class);
    }

    @Test
    public void test431MakesIllegalStateException() {
        this.assertCodeMakes("GET", URI.create("https://cloudstack.com/foo"), 431, "", "Method Not Allowed", IllegalStateException.class);
    }

    @Test
    public void test431MakesResourceNotFoundExceptionOnDelete() {
        this.assertCodeMakes("GET", URI.create("https://api.ninefold.com/compute/v1.0/?response=json&command=deleteSSHKeyPair"), 431, "", "{ \"deletekeypairresponse\" : {\"errorcode\" : 431, \"errortext\" : \"A key pair with name 'adriancole-adapter-test-keypair' does not exist for account jclouds in domain id=457\"}  }", ResourceNotFoundException.class);
    }

    @Test
    public void test409MakesIllegalStateException() {
        this.assertCodeMakes("GET", URI.create("https://cloudstack.com/foo"), 409, "", "Conflict", IllegalStateException.class);
    }

    @Test
    public void test531MakesAuthorizationException() {
        this.assertCodeMakes("GET", URI.create("https://cloudstack.com/foo"), 531, "", "Unauthoized", AuthorizationException.class);
    }

    @Test
    void test537MakesIllegalStateException() {
        this.assertCodeMakes("GET", URI.create("http://10.26.26.155:8080/client/api?response=json&command=createIpForwardingRule&ipaddressid=37&startport=22&protocol=tcp"), 537, "", "{ \"createipforwardingruleresponse\" : {\"errorcode\" : 537, \"errortext\" : \"There is already firewall rule specified for the ip address id=37\"}  }", IllegalStateException.class);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String content, Class<? extends Exception> expected) {
        this.assertCodeMakes(method, uri, statusCode, message, "text/xml", content, expected);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, Class<? extends Exception> expected) {
        CloudStackErrorHandler function = (CloudStackErrorHandler)Guice.createInjector((Module[])new Module[0]).getInstance(CloudStackErrorHandler.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method(method).endpoint(uri).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(statusCode).message(message).payload(content)).build();
        response.getPayload().getContentMetadata().setContentType(contentType);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(CloudStackErrorHandlerTest.classEq(expected));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }

    public static Exception classEq(final Class<? extends Exception> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("classEq(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in;
            }
        });
        return null;
    }
}

