/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.Cluster;
import org.jclouds.cloudstack.domain.Host;
import org.jclouds.cloudstack.options.UpdateClusterOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class UpdateClusterOptionsTest {
    public void testAllocationState() {
        UpdateClusterOptions options = new UpdateClusterOptions().allocationState(AllocationState.ENABLED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Enabled"), (Collection)options.buildQueryParameters().get((Object)"allocationstate"));
    }

    public void testAllocationStateStatic() {
        UpdateClusterOptions options = UpdateClusterOptions.Builder.allocationState((AllocationState)AllocationState.ENABLED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Enabled"), (Collection)options.buildQueryParameters().get((Object)"allocationstate"));
    }

    public void testClusterName() {
        UpdateClusterOptions options = new UpdateClusterOptions().clusterName("My Cluster");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"My Cluster"), (Collection)options.buildQueryParameters().get((Object)"clustername"));
    }

    public void testClusterType() {
        UpdateClusterOptions options = new UpdateClusterOptions().clusterType(Host.ClusterType.CLOUD_MANAGED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"CloudManaged"), (Collection)options.buildQueryParameters().get((Object)"clustertype"));
    }

    public void testHypervisor() {
        UpdateClusterOptions options = new UpdateClusterOptions().hypervisor("XenServer");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"XenServer"), (Collection)options.buildQueryParameters().get((Object)"hypervisor"));
    }

    public void testManagedState() {
        UpdateClusterOptions options = new UpdateClusterOptions().managedState(Cluster.ManagedState.PREPARE_UNMANAGED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"PrepareUnmanaged"), (Collection)options.buildQueryParameters().get((Object)"managedstate"));
    }
}

