/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.UncheckedExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.logging.Logger;

@Singleton
public class BlockUntilJobCompletesAndReturnResult {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudStackClient client;
    private final Predicate<String> jobComplete;

    @Inject
    public BlockUntilJobCompletesAndReturnResult(CloudStackClient client, Predicate<String> jobComplete) {
        this.client = (CloudStackClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.jobComplete = (Predicate)Preconditions.checkNotNull(jobComplete, (Object)"jobComplete");
    }

    public <T> T apply(AsyncCreateResponse job) {
        boolean completed = this.jobComplete.apply((Object)job.getJobId());
        this.logger.trace("<< job(%s) complete(%s)", new Object[]{job, completed});
        AsyncJob jobWithResult = this.client.getAsyncJobClient().getAsyncJob(job.getJobId());
        Preconditions.checkState((boolean)completed, (String)"job %s failed to complete in time %s", (Object[])new Object[]{job.getJobId(), jobWithResult});
        if (jobWithResult.getError() != null) {
            throw new UncheckedExecutionException(String.format("job %s failed with exception %s", job.getJobId(), jobWithResult.getError().toString())){
                private static final long serialVersionUID = 4371112085613620239L;
            };
        }
        return jobWithResult.getResult();
    }
}

