/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.CloudStackGlobalClient;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.Cluster;
import org.jclouds.cloudstack.domain.Host;
import org.jclouds.cloudstack.features.GlobalHostClient;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.AddClusterOptions;
import org.jclouds.cloudstack.options.AddHostOptions;
import org.jclouds.cloudstack.options.AddSecondaryStorageOptions;
import org.jclouds.cloudstack.options.DeleteHostOptions;
import org.jclouds.cloudstack.options.ListClustersOptions;
import org.jclouds.cloudstack.options.ListHostsOptions;
import org.jclouds.cloudstack.options.UpdateClusterOptions;
import org.jclouds.cloudstack.options.UpdateHostOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalConfigurationClientExpectTest")
public class GlobalHostClientExpectTest
extends BaseCloudStackExpectTest<GlobalHostClient> {
    @Test
    public void testListHostsWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=listHosts&listAll=true&apiKey=identity&signature=NnYyyEy30G3V2dcIt7w4WZ68AU8%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload(this.payloadFromResource("/listhostsresponse.json"))).statusCode(200).build();
        Set actual = ((GlobalHostClient)this.requestSendsResponse(request, response)).listHosts(new ListHostsOptions[0]);
        Date lastPinged = this.makeDate(1970, 0, 16, 0, 54, 43, "GMT+02:00");
        Date created = this.makeDate(2011, 10, 26, 23, 28, 36, "GMT+02:00");
        Host host1 = Host.builder().id("1").name("cs2-xevsrv.alucloud.local").state(Host.State.UP).type(Host.Type.ROUTING).ipAddress("10.26.26.107").zoneId("1").zoneName("Dev Zone 1").podId("1").podName("Dev Pod 1").version("2.2.12.20110928142833").hypervisor("XenServer").cpuNumber(24).cpuSpeed(2266).cpuAllocated("2.76%").cpuUsed("0.1%").cpuWithOverProvisioning(54384.0f).networkKbsRead(4443L).networkKbsWrite(15048L).memoryTotal(100549733760L).memoryAllocated(0xD8000000L).memoryUsed(0xD8000000L).capabilities("xen-3.0-x86_64 , xen-3.0-x86_32p , hvm-3.0-x86_32 , hvm-3.0-x86_32p , hvm-3.0-x86_64").lastPinged(lastPinged).managementServerId("223098941760041").clusterId("1").clusterName("Xen Clust 1").clusterType(Host.ClusterType.CLOUD_MANAGED).localStorageActive(false).created(created).events("PrepareUnmanaged; HypervisorVersionChanged; ManagementServerDown; PingTimeout; AgentDisconnected; MaintenanceRequested; HostDown; AgentConnected; StartAgentRebalance; ShutdownRequested; Ping").hasEnoughCapacity(false).allocationState(AllocationState.ENABLED).build();
        Date disconnected = this.makeDate(2011, 10, 26, 23, 33, 38, "GMT+02:00");
        lastPinged = this.makeDate(1970, 0, 16, 0, 42, 30, "GMT+02:00");
        created = this.makeDate(2011, 10, 26, 23, 33, 38, "GMT+02:00");
        Host host2 = Host.builder().id("2").name("nfs://10.26.26.165/mnt/nfs/cs_sec").state(Host.State.ALERT).disconnected(disconnected).type(Host.Type.SECONDARY_STORAGE).ipAddress("nfs").zoneId("1").zoneName("Dev Zone 1").version("2.2.12.20110928142833").hypervisor("None").lastPinged(lastPinged).localStorageActive(false).created(created).events("ManagementServerDown; AgentDisconnected; Remove; MaintenanceRequested; AgentConnected; Ping").hasEnoughCapacity(false).allocationState(AllocationState.ENABLED).build();
        lastPinged = this.makeDate(1970, 0, 16, 0, 54, 43, "GMT+02:00");
        created = this.makeDate(2011, 10, 26, 23, 35, 51, "GMT+02:00");
        Host host3 = Host.builder().id("3").name("s-1-VM").state(Host.State.UP).type(Host.Type.SECONDARY_STORAGE_VM).ipAddress("10.26.26.81").zoneId("1").zoneName("Dev Zone 1").podId("1").podName("Dev Pod 1").version("2.2.12.20110928142833").lastPinged(lastPinged).managementServerId("223098941760041").localStorageActive(false).created(created).events("PrepareUnmanaged; HypervisorVersionChanged; ManagementServerDown; PingTimeout; AgentDisconnected; MaintenanceRequested; HostDown; AgentConnected; StartAgentRebalance; ShutdownRequested; Ping").hasEnoughCapacity(false).allocationState(AllocationState.ENABLED).build();
        lastPinged = this.makeDate(1970, 0, 16, 0, 54, 43, "GMT+02:00");
        created = this.makeDate(2011, 10, 26, 23, 36, 46, "GMT+02:00");
        Host host4 = Host.builder().id("4").name("v-2-VM").state(Host.State.UP).type(Host.Type.CONSOLE_PROXY).ipAddress("10.26.26.96").zoneId("1").zoneName("Dev Zone 1").podId("1").podName("Dev Pod 1").version("2.2.12.20110928142833").lastPinged(lastPinged).managementServerId("223098941760041").localStorageActive(false).created(created).events("PrepareUnmanaged; HypervisorVersionChanged; ManagementServerDown; PingTimeout; AgentDisconnected; MaintenanceRequested; HostDown; AgentConnected; StartAgentRebalance; ShutdownRequested; Ping").hasEnoughCapacity(false).allocationState(AllocationState.ENABLED).build();
        ImmutableSet expected = ImmutableSet.of((Object)host1, (Object)host2, (Object)host3, (Object)host4);
        Assert.assertEquals((Set)actual, (Set)expected);
    }

    @Test
    public void testListHostsEmptyOn404() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=listHosts&listAll=true&apiKey=identity&signature=NnYyyEy30G3V2dcIt7w4WZ68AU8%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = HttpResponse.builder().statusCode(404).build();
        GlobalHostClient client = (GlobalHostClient)this.requestSendsResponse(request, response);
        Assert.assertEquals((Set)client.listHosts(new ListHostsOptions[0]), (Set)ImmutableSet.of());
    }

    @Test
    public void testAddHostWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=addHost&zoneid=1&hypervisor=XenServer&url=http%3A%2F%2Fexample.com&username=fred&password=sekrit&hosttags=&allocationstate=Enabled&clusterid=1&clustername=Xen%20Clust%201&podid=1&apiKey=identity&signature=ExGaljKKQIlVbWk5hd0BnnjmBzs%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload(this.payloadFromResource("/addhostresponse.json"))).statusCode(200).build();
        Date lastPinged = this.makeDate(1970, 0, 16, 0, 54, 43, "GMT+02:00");
        Date created = this.makeDate(2011, 10, 26, 23, 28, 36, "GMT+02:00");
        Host expected = Host.builder().id("1").name("cs2-xevsrv.alucloud.local").state(Host.State.UP).type(Host.Type.ROUTING).ipAddress("10.26.26.107").zoneId("1").zoneName("Dev Zone 1").podId("1").podName("Dev Pod 1").version("2.2.12.20110928142833").hypervisor("XenServer").cpuNumber(24).cpuSpeed(2266).cpuAllocated("2.76%").cpuUsed("0.1%").cpuWithOverProvisioning(54384.0f).networkKbsRead(4443L).networkKbsWrite(15048L).memoryTotal(100549733760L).memoryAllocated(0xD8000000L).memoryUsed(0xD8000000L).capabilities("xen-3.0-x86_64 , xen-3.0-x86_32p , hvm-3.0-x86_32 , hvm-3.0-x86_32p , hvm-3.0-x86_64").lastPinged(lastPinged).managementServerId("223098941760041").clusterId("1").clusterName("Xen Clust 1").clusterType(Host.ClusterType.CLOUD_MANAGED).localStorageActive(false).created(created).events("PrepareUnmanaged; HypervisorVersionChanged; ManagementServerDown; PingTimeout; AgentDisconnected; MaintenanceRequested; HostDown; AgentConnected; StartAgentRebalance; ShutdownRequested; Ping").hasEnoughCapacity(false).allocationState(AllocationState.ENABLED).build();
        Host actual = ((GlobalHostClient)this.requestSendsResponse(request, response)).addHost("1", "http://example.com", "XenServer", "fred", "sekrit", new AddHostOptions[]{AddHostOptions.Builder.hostTags(Collections.emptySet()).allocationState(AllocationState.ENABLED).clusterId("1").clusterName("Xen Clust 1").podId("1")});
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testUpdateHostWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=updateHost&id=1&allocationstate=Enabled&hosttags=&oscategoryid=5&apiKey=identity&signature=qTxNq9yQG8S108giqS%2FROFzgev8%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload(this.payloadFromResource("/updatehostresponse.json"))).statusCode(200).build();
        Date lastPinged = this.makeDate(1970, 0, 16, 0, 54, 43, "GMT+02:00");
        Date created = this.makeDate(2011, 10, 26, 23, 28, 36, "GMT+02:00");
        Host expected = Host.builder().id("1").name("cs2-xevsrv.alucloud.local").state(Host.State.UP).type(Host.Type.ROUTING).ipAddress("10.26.26.107").zoneId("1").zoneName("Dev Zone 1").podId("1").podName("Dev Pod 1").version("2.2.12.20110928142833").hypervisor("XenServer").cpuNumber(24).cpuSpeed(2266).cpuAllocated("2.76%").cpuUsed("0.1%").cpuWithOverProvisioning(54384.0f).networkKbsRead(4443L).networkKbsWrite(15048L).memoryTotal(100549733760L).memoryAllocated(0xD8000000L).memoryUsed(0xD8000000L).capabilities("xen-3.0-x86_64 , xen-3.0-x86_32p , hvm-3.0-x86_32 , hvm-3.0-x86_32p , hvm-3.0-x86_64").lastPinged(lastPinged).managementServerId("223098941760041").clusterId("1").clusterName("Xen Clust 1").clusterType(Host.ClusterType.CLOUD_MANAGED).localStorageActive(false).created(created).events("PrepareUnmanaged; HypervisorVersionChanged; ManagementServerDown; PingTimeout; AgentDisconnected; MaintenanceRequested; HostDown; AgentConnected; StartAgentRebalance; ShutdownRequested; Ping").hasEnoughCapacity(false).allocationState(AllocationState.ENABLED).build();
        Host actual = ((GlobalHostClient)this.requestSendsResponse(request, response)).updateHost("1", new UpdateHostOptions[]{UpdateHostOptions.Builder.allocationState((AllocationState)AllocationState.ENABLED).hostTags(Collections.emptySet()).osCategoryId("5")});
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testUpdateHostPasswordWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=updateHostPassword&hostid=1&password=sekrit&username=fred&apiKey=identity&signature=g9nMKDWoiU72y0HhaRFekZCgfJc%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = HttpResponse.builder().statusCode(200).build();
        ((GlobalHostClient)this.requestSendsResponse(request, response)).updateHostPassword("1", "fred", "sekrit");
    }

    @Test
    public void testDeleteHostWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=deleteHost&id=1&forced=true&forcedestroylocalstorage=true&apiKey=identity&signature=ZdvO1BWBkdPiDAjsVlKtqDe6N7k%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = HttpResponse.builder().statusCode(200).build();
        ((GlobalHostClient)this.requestSendsResponse(request, response)).deleteHost("1", new DeleteHostOptions[]{DeleteHostOptions.Builder.forced((boolean)true).forceDestroyLocalStorage(true)});
    }

    @Test
    public void testPrepareHostForMaintenanceWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=prepareHostForMaintenance&id=1&apiKey=identity&signature=9tDwdox%2FxAKmZr9kVrR6Ttnxf3U%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload(this.payloadFromResource("/preparehostformaintenanceresponse.json"))).statusCode(200).build();
        String actual = ((GlobalHostClient)this.requestSendsResponse(request, response)).prepareHostForMaintenance("1");
        Assert.assertEquals((String)actual, (String)"2036");
    }

    @Test
    public void testCancelHostMaintenanceWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=cancelHostMaintenance&id=1&apiKey=identity&signature=9RduzuBoyRZKNTzAoVqUo9gRTfk%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload(this.payloadFromResource("/cancelhostmaintenanceresponse.json"))).statusCode(200).build();
        String actual = ((GlobalHostClient)this.requestSendsResponse(request, response)).cancelHostMaintenance("1");
        Assert.assertEquals((String)actual, (String)"2036");
    }

    @Test
    public void testReconnectHostWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=reconnectHost&id=1&apiKey=identity&signature=wJEF02vwdyOnJOTa%2BWMMK906aRU%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload(this.payloadFromResource("/reconnecthostresponse.json"))).statusCode(200).build();
        String actual = ((GlobalHostClient)this.requestSendsResponse(request, response)).reconnectHost("1");
        Assert.assertEquals((String)actual, (String)"2036");
    }

    @Test
    public void testAddSecondaryStorageWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=addSecondaryStorage&url=nfs%3A%2F%2F10.26.26.165%2Fmnt%2Fnfs%2Fcs_sec&zoneid=1&apiKey=identity&signature=MccRKx1yPP43ImiO70WlhVDlAIA%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload(this.payloadFromResource("/addsecondarystorageresponse.json"))).statusCode(200).build();
        Date disconnected = this.makeDate(2011, 10, 26, 23, 33, 38, "GMT+02:00");
        Date lastPinged = this.makeDate(1970, 0, 16, 0, 42, 30, "GMT+02:00");
        Date created = this.makeDate(2011, 10, 26, 23, 33, 38, "GMT+02:00");
        Host expected = Host.builder().id("2").name("nfs://10.26.26.165/mnt/nfs/cs_sec").state(Host.State.ALERT).disconnected(disconnected).type(Host.Type.SECONDARY_STORAGE).ipAddress("nfs").zoneId("1").zoneName("Dev Zone 1").version("2.2.12.20110928142833").hypervisor("None").lastPinged(lastPinged).localStorageActive(false).created(created).events("ManagementServerDown; AgentDisconnected; Remove; MaintenanceRequested; AgentConnected; Ping").hasEnoughCapacity(false).allocationState(AllocationState.ENABLED).build();
        Host actual = ((GlobalHostClient)this.requestSendsResponse(request, response)).addSecondaryStorage("nfs://10.26.26.165/mnt/nfs/cs_sec", new AddSecondaryStorageOptions[]{AddSecondaryStorageOptions.Builder.zoneId((String)"1")});
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testListClustersWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=listClusters&listAll=true&apiKey=identity&signature=lbimqg0OKIq8sgQBpNmi4oQNFog%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload(this.payloadFromResource("/listclustersresponse.json"))).statusCode(200).build();
        Set actual = ((GlobalHostClient)this.requestSendsResponse(request, response)).listClusters(new ListClustersOptions[0]);
        Cluster cluster1 = Cluster.builder().id("1").name("Xen Clust 1").podId("1").podName("Dev Pod 1").zoneId("1").zoneName("Dev Zone 1").hypervisor("XenServer").clusterType(Host.ClusterType.CLOUD_MANAGED).allocationState(AllocationState.ENABLED).managedState(Cluster.ManagedState.MANAGED).build();
        Cluster cluster2 = Cluster.builder().id("2").name("Xen Clust 1").podId("2").podName("Dev Pod 2").zoneId("2").zoneName("Dev Zone 2").hypervisor("XenServer").clusterType(Host.ClusterType.CLOUD_MANAGED).allocationState(AllocationState.ENABLED).managedState(Cluster.ManagedState.MANAGED).build();
        ImmutableSet expected = ImmutableSet.of((Object)cluster1, (Object)cluster2);
        Assert.assertEquals((Set)actual, (Set)expected);
    }

    @Test
    public void testListClustersEmptyOn404() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=listClusters&listAll=true&apiKey=identity&signature=lbimqg0OKIq8sgQBpNmi4oQNFog%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = HttpResponse.builder().statusCode(404).build();
        GlobalHostClient client = (GlobalHostClient)this.requestSendsResponse(request, response);
        Assert.assertEquals((Set)client.listClusters(new ListClustersOptions[0]), (Set)ImmutableSet.of());
    }

    @Test
    public void testAddClusterWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=addCluster&zoneid=1&clustertype=CloudManaged&clustername=Xen%20Clust%201&hypervisor=XenServer&allocationstate=Enabled&podid=1&url=http%3A%2F%2Fexample.com%2Fcluster&username=fred&password=sekrit&apiKey=identity&signature=2uIQ5qF0bVycXK111wxvogWp1Yw%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload(this.payloadFromResource("/addclusterresponse.json"))).statusCode(200).build();
        Cluster expected = Cluster.builder().id("1").name("Xen Clust 1").podId("1").podName("Dev Pod 1").zoneId("1").zoneName("Dev Zone 1").hypervisor("XenServer").clusterType(Host.ClusterType.CLOUD_MANAGED).allocationState(AllocationState.ENABLED).managedState(Cluster.ManagedState.MANAGED).build();
        Cluster actual = ((GlobalHostClient)this.requestSendsResponse(request, response)).addCluster("1", "Xen Clust 1", Host.ClusterType.CLOUD_MANAGED, "XenServer", new AddClusterOptions[]{AddClusterOptions.Builder.allocationState((AllocationState)AllocationState.ENABLED).podId("1").url("http://example.com/cluster").username("fred").password("sekrit")});
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testUpdateClusterWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=updateCluster&id=1&allocationstate=Enabled&clustername=Xen%20Clust%201&clustertype=CloudManaged&hypervisor=XenServer&managedstate=Managed&apiKey=identity&signature=%2FwbuYKwInciSXWkUf05lEfJZShQ%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload(this.payloadFromResource("/updateclusterresponse.json"))).statusCode(200).build();
        Cluster expected = Cluster.builder().id("1").name("Xen Clust 1").podId("1").podName("Dev Pod 1").zoneId("1").zoneName("Dev Zone 1").hypervisor("XenServer").clusterType(Host.ClusterType.CLOUD_MANAGED).allocationState(AllocationState.ENABLED).managedState(Cluster.ManagedState.MANAGED).build();
        Cluster actual = ((GlobalHostClient)this.requestSendsResponse(request, response)).updateCluster("1", new UpdateClusterOptions[]{UpdateClusterOptions.Builder.allocationState((AllocationState)AllocationState.ENABLED).clusterName("Xen Clust 1").clusterType(Host.ClusterType.CLOUD_MANAGED).hypervisor("XenServer").managedState(Cluster.ManagedState.MANAGED)});
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testUpdateClusterPasswordWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=updateHostPassword&clusterid=1&password=sekrit&username=fred&apiKey=identity&signature=xwc83%2BoYK0cuAiFQAlg%2F7%2F1IVHE%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = HttpResponse.builder().statusCode(200).build();
        ((GlobalHostClient)this.requestSendsResponse(request, response)).updateClusterPassword("1", "fred", "sekrit");
    }

    @Test
    public void testDeleteClusterWhenResponseIs2xx() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=deleteCluster&id=1&apiKey=identity&signature=CKH26MFgKGY7Sosd17LjBMNa3AI%3D").addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse response = HttpResponse.builder().statusCode(200).build();
        ((GlobalHostClient)this.requestSendsResponse(request, response)).deleteCluster("1");
    }

    private Date makeDate(int year, int month, int date, int hour, int minute, int second, String timeZoneName) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timeZoneName));
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, date);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, 0);
        return cal.getTime();
    }

    @Override
    protected GlobalHostClient clientFrom(CloudStackContext context) {
        return ((CloudStackGlobalClient)context.getGlobalContext().getApi()).getHostClient();
    }
}

