/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.util.concurrent.UncheckedExecutionException;
import org.easymock.EasyMock;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.domain.AsyncJobError;
import org.jclouds.cloudstack.features.AsyncJobClient;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BlockUntilJobCompletesAndReturnResultTest")
public class BlockUntilJobCompletesAndReturnResultTest {
    public void testApply() {
        String id = "1";
        String jobId = "2";
        CloudStackClient client = (CloudStackClient)EasyMock.createMock(CloudStackClient.class);
        Predicate jobComplete = Predicates.alwaysTrue();
        AsyncJobClient jobClient = (AsyncJobClient)EasyMock.createMock(AsyncJobClient.class);
        EasyMock.expect((Object)client.getAsyncJobClient()).andReturn((Object)jobClient).atLeastOnce();
        EasyMock.expect((Object)jobClient.getAsyncJob(jobId)).andReturn((Object)AsyncJob.builder().id(jobId).result((Object)"foo").build()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{jobClient});
        Assert.assertEquals((String)((String)new BlockUntilJobCompletesAndReturnResult(client, jobComplete).apply(AsyncCreateResponse.builder().id(id).jobId(jobId).build())), (String)"foo");
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{jobClient});
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testJobDoesntCompleteThrowsIllegalStateException() {
        String id = "1";
        String jobId = "2";
        CloudStackClient client = (CloudStackClient)EasyMock.createMock(CloudStackClient.class);
        Predicate jobComplete = Predicates.alwaysFalse();
        AsyncJobClient jobClient = (AsyncJobClient)EasyMock.createMock(AsyncJobClient.class);
        EasyMock.expect((Object)client.getAsyncJobClient()).andReturn((Object)jobClient).atLeastOnce();
        EasyMock.expect((Object)jobClient.getAsyncJob(jobId)).andReturn((Object)AsyncJob.builder().id(jobId).result((Object)"foo").build()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{jobClient});
        Assert.assertEquals((String)((String)new BlockUntilJobCompletesAndReturnResult(client, jobComplete).apply(AsyncCreateResponse.builder().id(id).jobId(jobId).build())), (String)"foo");
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{jobClient});
    }

    @Test(expectedExceptions={UncheckedExecutionException.class})
    public void testJobWithErrorThrowsUncheckedExecutionException() {
        String id = "1";
        String jobId = "2";
        CloudStackClient client = (CloudStackClient)EasyMock.createMock(CloudStackClient.class);
        Predicate jobComplete = Predicates.alwaysTrue();
        AsyncJobClient jobClient = (AsyncJobClient)EasyMock.createMock(AsyncJobClient.class);
        EasyMock.expect((Object)client.getAsyncJobClient()).andReturn((Object)jobClient).atLeastOnce();
        EasyMock.expect((Object)jobClient.getAsyncJob(jobId)).andReturn((Object)AsyncJob.builder().id(jobId).error(AsyncJobError.builder().errorCode(AsyncJobError.ErrorCode.INTERNAL_ERROR).errorText("ERRROR").build()).result((Object)"foo").build()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{jobClient});
        Assert.assertEquals((String)((String)new BlockUntilJobCompletesAndReturnResult(client, jobComplete).apply(AsyncCreateResponse.builder().id(id).jobId(jobId).build())), (String)"foo");
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{jobClient});
    }
}

