/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.List;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.CloudStackGlobalClient;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.features.GlobalZoneClient;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.CreateZoneOptions;
import org.jclouds.cloudstack.options.UpdateZoneOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalZoneClientExpectTest")
public class GlobalZoneClientExpectTest
extends BaseCloudStackExpectTest<GlobalZoneClient> {
    public void testCreateZoneWhenResponseIs2xxAnd404() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=createZone&name=test-zone&dns1=8.8.8.8&networktype=Basic&internaldns1=10.10.10.10&apiKey=identity&signature=hWNmM2%2BTsfb5DelQa/GJLN5DVWE%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build())).build();
        GlobalZoneClient client = (GlobalZoneClient)this.requestSendsResponse(request, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createzoneresponse.json"))).build());
        Assert.assertEquals((Object)client.createZone("test-zone", NetworkType.BASIC, "8.8.8.8", "10.10.10.10", new CreateZoneOptions[0]), (Object)Zone.builder().id("6").name("test-zone").DNS((List)ImmutableList.of((Object)"8.8.8.8")).internalDNS((List)ImmutableList.of((Object)"10.10.10.10")).networkType(NetworkType.BASIC).securityGroupsEnabled(true).allocationState(AllocationState.ENABLED).zoneToken("7b6e27df-30a6-3024-9d8b-7971a3127f64").dhcpProvider("DhcpServer").build());
        client = (GlobalZoneClient)this.requestSendsResponse(request, HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.createZone("test-zone", NetworkType.BASIC, "8.8.8.8", "10.10.10.10", new CreateZoneOptions[0]));
    }

    public void testUpdateZoneWhenResponseIs2xxAnd404() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=updateZone&id=6&name=test-zone&dns1=8.8.8.8&apiKey=identity&signature=v19FdHKHztdT0IRloYFFn0eNbWM%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build())).build();
        GlobalZoneClient client = (GlobalZoneClient)this.requestSendsResponse(request, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/updatezoneresponse.json"))).build());
        Assert.assertEquals((Object)client.updateZone("6", new UpdateZoneOptions[]{UpdateZoneOptions.Builder.name((String)"test-zone").externalDns((List)ImmutableList.of((Object)"8.8.8.8"))}), (Object)Zone.builder().id("6").name("test-zone").DNS((List)ImmutableList.of((Object)"8.8.8.8")).internalDNS((List)ImmutableList.of((Object)"10.10.10.10")).networkType(NetworkType.BASIC).securityGroupsEnabled(true).allocationState(AllocationState.ENABLED).zoneToken("7b6e27df-30a6-3024-9d8b-7971a3127f64").dhcpProvider("DhcpServer").build());
        client = (GlobalZoneClient)this.requestSendsResponse(request, HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.updateZone("6", new UpdateZoneOptions[]{UpdateZoneOptions.Builder.name((String)"test-zone").externalDns((List)ImmutableList.of((Object)"8.8.8.8"))}));
    }

    public void testDeleteZone() {
        GlobalZoneClient client = (GlobalZoneClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=deleteZone&id=6&apiKey=identity&signature=TfkzSIK8kzGJnIYo3DofECyuOII%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deletezoneresponse.json"))).build());
        client.deleteZone("6");
    }

    @Override
    protected GlobalZoneClient clientFrom(CloudStackContext context) {
        return ((CloudStackGlobalClient)context.getGlobalContext().getApi()).getZoneClient();
    }
}

