/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.filters;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import org.jclouds.ContextBuilder;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.IntegrationTestAsyncClient;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="QuerySignerTest")
public class QuerySignerTest {
    public static final Injector INJECTOR = ContextBuilder.newBuilder((ProviderMetadata)AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(IntegrationTestClient.class, IntegrationTestAsyncClient.class, (String)"http://localhost:8080/client/api")).credentials("apiKey", "secretKey").apiVersion("2.2").modules((Iterable)ImmutableList.of((Object)new BaseRestApiTest.MockModule(), (Object)new NullLoggingModule())).buildInjector();

    @Test
    void testCreateStringToSign() {
        QuerySigner filter = (QuerySigner)INJECTOR.getInstance(QuerySigner.class);
        Assert.assertEquals((String)filter.createStringToSign(HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?command=listZones").build()), (String)"apikey=apikey&command=listzones");
    }

    @Test
    void testFilter() {
        QuerySigner filter = (QuerySigner)INJECTOR.getInstance(QuerySigner.class);
        Assert.assertEquals((String)filter.filter(HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?command=listZones").build()).getRequestLine(), (String)"GET http://localhost:8080/client/api?command=listZones&apiKey=apiKey&signature=2UG8AcnMaozL3BINdjgkJ%2BRzjEY%3D HTTP/1.1");
    }

    @Test
    void testFilterTwice() {
        QuerySigner filter = (QuerySigner)INJECTOR.getInstance(QuerySigner.class);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?command=listZones").build();
        for (int i = 0; i < 2; ++i) {
            request = filter.filter(request);
            Assert.assertEquals((String)request.getRequestLine(), (String)"GET http://localhost:8080/client/api?command=listZones&apiKey=apiKey&signature=2UG8AcnMaozL3BINdjgkJ%2BRzjEY%3D HTTP/1.1");
        }
    }
}

