/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.CloudStackGlobalClient;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.Pod;
import org.jclouds.cloudstack.features.GlobalPodClient;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.CreatePodOptions;
import org.jclouds.cloudstack.options.ListPodsOptions;
import org.jclouds.cloudstack.options.UpdatePodOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalPodClientExpectTest")
public class GlobalPodClientExpectTest
extends BaseCloudStackExpectTest<GlobalPodClient> {
    public void testListPodsWhenResponseIs2xx() {
        GlobalPodClient client = (GlobalPodClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listPods&listAll=true&apiKey=identity&signature=MuowIOuZqOpKTPVQOfrDZEmpepw%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build())).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listpodsresponse.json"))).build());
        Pod pod1 = Pod.builder().id("1").name("Dev Pod 1").zoneId("1").zoneName("Dev Zone 1").gateway("10.26.26.254").netmask("255.255.255.0").startIp("10.26.26.50").endIp("10.26.26.100").allocationState(AllocationState.ENABLED).build();
        Pod pod2 = Pod.builder().id("2").name("Dev Pod 2").zoneId("2").zoneName("Dev Zone 2").gateway("10.22.22.254").netmask("255.255.255.0").startIp("10.22.22.25").endIp("10.22.22.50").allocationState(AllocationState.ENABLED).build();
        Assert.assertEquals((Set)client.listPods(new ListPodsOptions[0]), (Set)ImmutableSet.of((Object)pod1, (Object)pod2));
    }

    public void testListPodsWhenResponseIs404() {
        GlobalPodClient client = (GlobalPodClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listPods&listAll=true&apiKey=identity&signature=MuowIOuZqOpKTPVQOfrDZEmpepw%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build())).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listPods(new ListPodsOptions[0]), (Set)ImmutableSet.of());
    }

    public void testCreatePodWhenResponseIs2xx() {
        GlobalPodClient client = (GlobalPodClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=createPod&netmask=255.255.255.0&name=richard-pod&startip=172.20.0.1&zoneid=10&endip=172.20.0.250&gateway=172.20.0.254&allocationstate=Enabled&apiKey=identity&signature=fwsoQ77BmNQWfuqv4nVlPcKvKbU%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build())).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createpodresponse.json"))).build());
        Pod expected = Pod.builder().id("6").name("richard-pod").zoneId("10").zoneName("richard-zone").gateway("172.20.0.254").netmask("255.255.255.0").startIp("172.20.0.1").endIp("172.20.0.250").allocationState(AllocationState.ENABLED).build();
        Pod actual = client.createPod("richard-pod", "10", "172.20.0.1", "172.20.0.250", "172.20.0.254", "255.255.255.0", new CreatePodOptions[]{CreatePodOptions.Builder.allocationState((AllocationState)AllocationState.ENABLED)});
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    public void testUpdatePodWhenResponseIs2xx() {
        GlobalPodClient client = (GlobalPodClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=updatePod&id=7&netmask=255.255.255.128&name=richard-updatepod&startip=172.21.0.129&endip=172.21.0.250&gateway=172.21.0.254&allocationstate=Disabled&apiKey=identity&signature=QpdbRyyF/xJ78ioJWhPKXEWhthY%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build())).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/updatepodresponse.json"))).build());
        Pod expected = Pod.builder().id("7").name("richard-updatedpod").zoneId("11").zoneName("richard-zone").gateway("172.21.0.254").netmask("255.255.255.128").startIp("172.21.0.129").endIp("172.21.0.250").allocationState(AllocationState.DISABLED).build();
        Pod actual = client.updatePod("7", new UpdatePodOptions[]{UpdatePodOptions.Builder.netmask((String)"255.255.255.128").name("richard-updatepod").startIp("172.21.0.129").endIp("172.21.0.250").gateway("172.21.0.254").allocationState(AllocationState.DISABLED)});
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    public void testDeletePodWhenResponseIs2xx() {
        GlobalPodClient client = (GlobalPodClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=deletePod&id=3&apiKey=identity&signature=rm4ItuAL1Ztnj%2BHFFvBFzvHAIog%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build())).build(), HttpResponse.builder().statusCode(200).build());
        client.deletePod("3");
    }

    @Override
    protected GlobalPodClient clientFrom(CloudStackContext context) {
        return ((CloudStackGlobalClient)context.getGlobalContext().getApi()).getPodClient();
    }
}

