/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.URI;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.cloudstack.features.SessionClient;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="SessionClientExpectTest")
public class SessionClientExpectTest
extends BaseCloudStackExpectTest<SessionClient> {
    public void testLoginWhenResponseIs2xxIncludesJSessionId() throws IOException {
        String domain = "Partners/jCloud";
        String user = "jcloud";
        String password = "jcl0ud";
        String md5password = CryptoStreams.md5Hex((String)password);
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=login&username=" + user + "&password=" + md5password + "&domain=" + domain)).addHeader("Accept", new String[]{"application/json"})).build();
        String jSessionId = "90DD65D13AEAA590ECCA312D150B9F6D";
        SessionClient client = (SessionClient)this.requestSendsResponse(request, ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).headers((Multimap)ImmutableMultimap.builder().put((Object)"Set-Cookie", (Object)("JSESSIONID=" + jSessionId + "; Path=/client")).build())).payload(this.payloadFromResource("/loginresponse.json"))).build());
        Assert.assertEquals((String)client.loginUserInDomainWithHashOfPassword(user, domain, md5password).toString(), (String)LoginResponse.builder().timeout(1800L).lastName("Kiran").registered(false).username("jcloud").firstName("Vijay").domainId("11").accountType(Account.Type.DOMAIN_ADMIN).userId("19").sessionKey("uYT4/MNiglgAKiZRQkvV8QP8gn0=").jSessionId(jSessionId).accountName("jcloud").build().toString());
    }

    public void testLogout() throws IOException {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=logout&sessionkey=dummy-session-key")).build();
        SessionClient client = (SessionClient)this.requestSendsResponse(request, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/logoutresponse.json"))).build());
        client.logoutUser("dummy-session-key");
    }

    @Override
    protected SessionClient clientFrom(CloudStackContext context) {
        return ((CloudStackClient)context.getProviderSpecificContext().getApi()).getSessionClient();
    }
}

