/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.DiskOffering;
import org.jclouds.cloudstack.domain.Snapshot;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Volume;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListDiskOfferingsOptions;
import org.jclouds.cloudstack.options.ListSnapshotsOptions;
import org.jclouds.cloudstack.options.ListVirtualMachinesOptions;
import org.jclouds.cloudstack.options.ListVolumesOptions;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.PredicateCallable;
import org.jclouds.predicates.PredicateWithResult;
import org.jclouds.predicates.Retryables;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="VolumeClientLiveTest")
public class VolumeClientLiveTest
extends BaseCloudStackClientLiveTest {
    @Resource
    Logger logger = Logger.NULL;
    protected String prefix = System.getProperty("user.name") + "-" + ((Object)((Object)this)).getClass().getSimpleName();
    private String zoneId;

    @BeforeMethod(groups={"live"})
    public void setZoneId() {
        Set zones = this.client.getZoneClient().listZones(new ListZonesOptions[0]);
        AssertJUnit.assertNotNull((Object)zones);
        AssertJUnit.assertFalse((boolean)zones.isEmpty());
        this.zoneId = ((Zone)Iterables.get((Iterable)zones, (int)0)).getId();
    }

    public void testListVolumes() {
        Set volumes = this.client.getVolumeClient().listVolumes(new ListVolumesOptions[0]);
        AssertJUnit.assertNotNull((Object)volumes);
        AssertJUnit.assertFalse((boolean)volumes.isEmpty());
        for (Volume volume : volumes) {
            VolumeClientLiveTest.checkVolume(volume);
        }
    }

    public void testListVolumesById() {
        Iterable volumeIds = Iterables.transform((Iterable)this.client.getVolumeClient().listVolumes(new ListVolumesOptions[0]), (Function)new Function<Volume, String>(){

            public String apply(Volume input) {
                return input.getId();
            }
        });
        AssertJUnit.assertNotNull((Object)volumeIds);
        AssertJUnit.assertFalse((boolean)Iterables.isEmpty((Iterable)volumeIds));
        for (String id : volumeIds) {
            Set found = this.client.getVolumeClient().listVolumes(new ListVolumesOptions[]{ListVolumesOptions.Builder.id((String)id)});
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((int)1, (int)found.size());
            Volume volume = (Volume)Iterables.getOnlyElement((Iterable)found);
            AssertJUnit.assertEquals((String)id, (String)volume.getId());
            VolumeClientLiveTest.checkVolume(volume);
        }
    }

    public void testListVolumesNonexistantId() {
        Set found = this.client.getVolumeClient().listVolumes(new ListVolumesOptions[]{ListVolumesOptions.Builder.id((String)"foo")});
        AssertJUnit.assertNotNull((Object)found);
        AssertJUnit.assertTrue((boolean)found.isEmpty());
    }

    public void testGetVolumeById() {
        Iterable volumeIds = Iterables.transform((Iterable)this.client.getVolumeClient().listVolumes(new ListVolumesOptions[0]), (Function)new Function<Volume, String>(){

            public String apply(Volume input) {
                return input.getId();
            }
        });
        AssertJUnit.assertNotNull((Object)volumeIds);
        AssertJUnit.assertFalse((boolean)Iterables.isEmpty((Iterable)volumeIds));
        for (String id : volumeIds) {
            Volume found = this.client.getVolumeClient().getVolume(id);
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((String)id, (String)found.getId());
            VolumeClientLiveTest.checkVolume(found);
        }
    }

    public void testGetVolumeNonexistantId() {
        Volume found = this.client.getVolumeClient().getVolume("foo");
        AssertJUnit.assertNull((Object)found);
    }

    protected DiskOffering getPreferredDiskOffering() {
        Iterator i$ = this.client.getOfferingClient().listDiskOfferings(new ListDiskOfferingsOptions[0]).iterator();
        if (i$.hasNext()) {
            DiskOffering candidate = (DiskOffering)i$.next();
            return candidate;
        }
        throw new AssertionError((Object)"No suitable DiskOffering found.");
    }

    protected Snapshot getPreferredSnapshot() {
        for (Snapshot candidate : this.client.getSnapshotClient().listSnapshots(new ListSnapshotsOptions[0])) {
            if (candidate.getState() != Snapshot.State.BACKED_UP) continue;
            return candidate;
        }
        throw new AssertionError((Object)"No suitable Snapshot found.");
    }

    protected VirtualMachine getPreferredVirtualMachine() {
        for (VirtualMachine candidate : this.client.getVirtualMachineClient().listVirtualMachines(new ListVirtualMachinesOptions[0])) {
            if (candidate.getState() != VirtualMachine.State.RUNNING && candidate.getState() != VirtualMachine.State.STOPPED) continue;
            return candidate;
        }
        throw new AssertionError((Object)"No suitable VirtualMachine found.");
    }

    protected Volume createPreferredVolumeFromDisk() {
        return (Volume)Retryables.retryGettingResultOrFailing((PredicateWithResult)new PredicateCallable<Volume>(){

            public Volume call() {
                AsyncCreateResponse job = VolumeClientLiveTest.this.client.getVolumeClient().createVolumeFromDiskOfferingInZone(VolumeClientLiveTest.this.prefix + "-jclouds-volume", VolumeClientLiveTest.this.getPreferredDiskOffering().getId(), VolumeClientLiveTest.this.zoneId);
                AssertJUnit.assertTrue((boolean)VolumeClientLiveTest.this.jobComplete.apply((Object)job.getJobId()));
                VolumeClientLiveTest.this.logger.info("created volume " + job.getId(), new Object[0]);
                return VolumeClientLiveTest.this.findVolumeWithId(job.getId());
            }
        }, null, (long)60000L, (String)"failed to create volume");
    }

    public void testCreateVolumeFromDiskofferingInZoneAndDeleteVolume() {
        this.logger.info("testCreateVolumeFromDiskofferingInZoneAndDeleteVolume", new Object[0]);
        Volume volume = this.createPreferredVolumeFromDisk();
        VolumeClientLiveTest.checkVolume(volume);
        this.client.getVolumeClient().deleteVolume(volume.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateVolumeFromDiskofferingInZoneAndAttachVolumeToVirtualMachineAndDetachAndDelete() {
        this.logger.info("testCreateVolumeFromDiskofferingInZoneAndAttachVolumeToVirtualMachineAndDetachAndDelete", new Object[0]);
        final Volume volume = this.createPreferredVolumeFromDisk();
        try {
            VolumeClientLiveTest.checkVolume(volume);
            final VirtualMachine virtualMachine = this.getPreferredVirtualMachine();
            Volume attachedVolume = (Volume)Retryables.retryGettingResultOrFailing((PredicateWithResult)new PredicateCallable<Volume>(){
                int failures = 0;

                public Volume call() {
                    VolumeClientLiveTest.this.logger.info("attaching volume %s to vm %s", new Object[]{volume, virtualMachine});
                    AsyncCreateResponse job = VolumeClientLiveTest.this.client.getVolumeClient().attachVolume(volume.getId(), virtualMachine.getId());
                    AssertJUnit.assertTrue((boolean)VolumeClientLiveTest.this.jobComplete.apply((Object)job.getJobId()));
                    return VolumeClientLiveTest.this.findVolumeWithId(volume.getId());
                }

                protected void onFailure() {
                    VolumeClientLiveTest.this.logger.info("failed attaching volume (retrying): %s", new Object[]{this.getLastFailure()});
                    if (this.failures++ == 0) {
                        VolumeClientLiveTest.this.logger.warn(this.getLastFailure(), "first failure attaching volume", new Object[0]);
                    }
                }
            }, null, (long)60000L, (String)"failed to attach volume");
            VolumeClientLiveTest.checkVolume(attachedVolume);
            AssertJUnit.assertEquals((String)virtualMachine.getId(), (String)attachedVolume.getVirtualMachineId());
            AssertJUnit.assertNotNull((Object)attachedVolume.getAttached());
            Volume detachedVolume = (Volume)Retryables.retryGettingResultOrFailing((PredicateWithResult)new PredicateCallable<Volume>(){

                public Volume call() {
                    VolumeClientLiveTest.this.logger.info("detaching volume %s from vm %s", new Object[]{volume, virtualMachine});
                    AsyncCreateResponse job = VolumeClientLiveTest.this.client.getVolumeClient().detachVolume(volume.getId());
                    AssertJUnit.assertTrue((boolean)VolumeClientLiveTest.this.jobComplete.apply((Object)job.getJobId()));
                    return VolumeClientLiveTest.this.findVolumeWithId(volume.getId());
                }

                protected void onFailure() {
                    VolumeClientLiveTest.this.logger.debug("failed detaching volume (retrying): %s", new Object[]{this.getLastFailure()});
                }
            }, null, (long)60000L, (String)"failed to detach volume");
            VolumeClientLiveTest.checkVolume(detachedVolume);
            AssertJUnit.assertNull((Object)detachedVolume.getAttached());
        }
        finally {
            this.client.getVolumeClient().deleteVolume(volume.getId());
        }
    }

    public void testCreateVolumeFromSnapshotInZoneAndDeleteVolume() {
        this.logger.info("testCreateVolumeFromSnapshotInZoneAndDeleteVolume (takes ~3m)", new Object[0]);
        AssertJUnit.assertNotNull((Object)this.getPreferredSnapshot());
        Volume volume = (Volume)Retryables.retryGettingResultOrFailing((PredicateWithResult)new PredicateCallable<Volume>(){

            public Volume call() {
                AsyncCreateResponse job = VolumeClientLiveTest.this.client.getVolumeClient().createVolumeFromSnapshotInZone(VolumeClientLiveTest.this.prefix + "-jclouds-volume", VolumeClientLiveTest.this.getPreferredSnapshot().getId(), VolumeClientLiveTest.this.zoneId);
                AssertJUnit.assertTrue((boolean)VolumeClientLiveTest.this.jobComplete.apply((Object)job.getJobId()));
                return VolumeClientLiveTest.this.findVolumeWithId(job.getId());
            }

            protected void onFailure() {
                VolumeClientLiveTest.this.logger.debug("failed creating volume (retrying): %s", new Object[]{this.getLastFailure()});
            }
        }, null, (long)60000L, (String)"failed to create volume");
        VolumeClientLiveTest.checkVolume(volume);
        this.client.getVolumeClient().deleteVolume(volume.getId());
    }

    static void checkVolume(Volume volume) {
        AssertJUnit.assertNotNull((Object)volume.getId());
        AssertJUnit.assertNotNull((Object)volume.getName());
        AssertJUnit.assertNotSame((Object)Volume.Type.UNRECOGNIZED, (Object)volume.getType());
    }

    Volume findVolumeWithId(String id) {
        return VolumeClientLiveTest.findVolumeWithId(this.client, id);
    }

    static Volume findVolumeWithId(CloudStackClient client, String id) {
        for (Volume v : client.getVolumeClient().listVolumes(new ListVolumesOptions[0])) {
            if (!v.getId().equals(id)) continue;
            return v;
        }
        throw new NoSuchElementException("no volume with id " + id);
    }
}

