/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.cloudstack.options.ListVlanIPRangesOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListVlanIPRangesOptionsTest {
    public void testAccountInDomain() {
        ListVlanIPRangesOptions options = new ListVlanIPRangesOptions().accountInDomain("fred", "19");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"fred"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"19"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testAccountInDomainStatic() {
        ListVlanIPRangesOptions options = ListVlanIPRangesOptions.Builder.accountInDomain((String)"fred", (String)"19");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"fred"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"19"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testDomainId() {
        ListVlanIPRangesOptions options = new ListVlanIPRangesOptions().domainId("19");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"19"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testDomainIdStatic() {
        ListVlanIPRangesOptions options = ListVlanIPRangesOptions.Builder.domainId((String)"19");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"19"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testForVirtualNetwork() {
        ListVlanIPRangesOptions options = new ListVlanIPRangesOptions().forVirtualNetwork(true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"forvirtualnetwork"));
    }

    public void testForVirtualNetworkStatic() {
        ListVlanIPRangesOptions options = ListVlanIPRangesOptions.Builder.forVirtualNetwork((boolean)true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"forvirtualnetwork"));
    }

    public void testId() {
        ListVlanIPRangesOptions options = new ListVlanIPRangesOptions().id("6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testIdStatic() {
        ListVlanIPRangesOptions options = ListVlanIPRangesOptions.Builder.id((String)"6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testKeyword() {
        ListVlanIPRangesOptions options = new ListVlanIPRangesOptions().keyword("fred");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"fred"), (Collection)options.buildQueryParameters().get((Object)"keyword"));
    }

    public void testKeywordStatic() {
        ListVlanIPRangesOptions options = ListVlanIPRangesOptions.Builder.keyword((String)"fred");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"fred"), (Collection)options.buildQueryParameters().get((Object)"keyword"));
    }

    public void testNetworkId() {
        ListVlanIPRangesOptions options = new ListVlanIPRangesOptions().networkId("209");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"209"), (Collection)options.buildQueryParameters().get((Object)"networkid"));
    }

    public void testNetworkIdStatic() {
        ListVlanIPRangesOptions options = ListVlanIPRangesOptions.Builder.networkId((String)"209");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"209"), (Collection)options.buildQueryParameters().get((Object)"networkid"));
    }

    public void testPodId() {
        ListVlanIPRangesOptions options = new ListVlanIPRangesOptions().podId("13");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"13"), (Collection)options.buildQueryParameters().get((Object)"podid"));
    }

    public void testPodIdStatic() {
        ListVlanIPRangesOptions options = ListVlanIPRangesOptions.Builder.podId((String)"13");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"13"), (Collection)options.buildQueryParameters().get((Object)"podid"));
    }

    public void testVlan() {
        ListVlanIPRangesOptions options = new ListVlanIPRangesOptions().vlan(1001L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1001"), (Collection)options.buildQueryParameters().get((Object)"vlan"));
    }

    public void testVlanStatic() {
        ListVlanIPRangesOptions options = ListVlanIPRangesOptions.Builder.vlan((long)1001L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1001"), (Collection)options.buildQueryParameters().get((Object)"vlan"));
    }

    public void testZoneId() {
        ListVlanIPRangesOptions options = new ListVlanIPRangesOptions().zoneId("6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }

    public void testZoneIdStatic() {
        ListVlanIPRangesOptions options = ListVlanIPRangesOptions.Builder.zoneId((String)"6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }
}

