/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack;

import java.util.Properties;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.features.AccountClient;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.ListAccountsOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="PasswordAuthenticationExpectTest")
public class PasswordAuthenticationExpectTest
extends BaseCloudStackExpectTest<CloudStackContext> {
    protected Properties setupProperties() {
        Properties contextProperties = super.setupProperties();
        contextProperties.setProperty("jclouds.cloudstack.credential-type", "passwordCredentials");
        return contextProperties;
    }

    public void testLoginWithPasswordSetsSessionKeyAndCookie() {
        CloudStackContext context = (CloudStackContext)this.requestsSendResponses(this.login, this.loginResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=listAccounts&listAll=true&sessionkey=" + Strings2.urlEncode((String)"uYT4/MNiglgAKiZRQkvV8QP8gn0=", (char[])new char[]{'/'})).addHeader("Accept", new String[]{"application/json"})).addHeader("Cookie", new String[]{"JSESSIONID=90DD65D13AEAA590ECCA312D150B9F6D"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listaccountsresponse.json"))).build(), this.logout, this.logoutResponse);
        AccountClient client = ((CloudStackClient)context.getProviderSpecificContext().getApi()).getAccountClient();
        Assert.assertNotNull((Object)client.listAccounts(new ListAccountsOptions[0]));
        context.close();
    }

    @Override
    protected CloudStackContext clientFrom(CloudStackContext context) {
        return context;
    }
}

