/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.ISO;
import org.jclouds.cloudstack.features.ISOClient;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.ListISOsOptions;
import org.jclouds.cloudstack.options.RegisterISOOptions;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ISOClientExpectTest")
public class ISOClientExpectTest
extends BaseCloudStackExpectTest<ISOClient> {
    private static final ISO iso1 = ISO.builder().id("018e0928-8205-4d8e-9329-f731a9ccd488").name("xs-tools.iso").displayText("xen-pv-drv-iso").isPublic(true).created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2012-08-21T15:45:01+0530")).isReady(true).passwordEnabled(false).bootable(false).isFeatured(true).crossZones(false).account("system").domain("ROOT").domainid("9d189ea2-097e-4b2b-9bae-d885f5430d69").isExtractable(false).build();
    private static final ISO iso2 = ISO.builder().id("1e29244b-9cf0-4ff2-9978-677eb83f6bfb").name("vmware-tools.iso").displayText("VMware Tools Installer ISO").isPublic(true).created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2012-08-21T15:45:01+0530")).isReady(true).passwordEnabled(false).bootable(false).isFeatured(true).crossZones(false).account("system").domain("ROOT").domainid("9d189ea2-097e-4b2b-9bae-d885f5430d69").isExtractable(false).build();
    HttpRequest listIsos = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listIsos"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"qUUF6hCDc57Bc/nHriS9umbZBKA%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
    HttpRequest listIsosOptions = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listIsos"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("account", new String[]{"fred"}).addQueryParam("domainid", new String[]{"5"}).addQueryParam("bootable", new String[]{"true"}).addQueryParam("hypervisor", new String[]{"xen"}).addQueryParam("id", new String[]{"3"}).addQueryParam("isofilter", new String[]{"featured"}).addQueryParam("ispublic", new String[]{"true"}).addQueryParam("isready", new String[]{"true"}).addQueryParam("keyword", new String[]{"bob"}).addQueryParam("name", new String[]{"bob%27s%20iso"}).addQueryParam("zoneid", new String[]{"7"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"4S5ustbaBErEnpymWLSj1rEJ/nk%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
    HttpRequest getIso = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listIsos"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("id", new String[]{"018e0928-8205-4d8e-9329-f731a9ccd488"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"uZyPUJt6ThMDcQSDa%2BEv5LMs%2B2U%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
    HttpRequest registerIso = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"registerIso"}).addQueryParam("name", new String[]{"ubuntu10.10"}).addQueryParam("url", new String[]{"http://ubuntu/ubuntu-10.10.iso"}).addQueryParam("displaytext", new String[]{"ubuntu 10.10 (32 bit)"}).addQueryParam("zoneid", new String[]{"1e0335d9-b6cc-4805-bddf-0828e66a0d01"}).addQueryParam("account", new String[]{"root"}).addQueryParam("domainid", new String[]{"99f4159b-c698-4bd9-b8c5-5ac462f101eb"}).addQueryParam("bootable", new String[]{"true"}).addQueryParam("isextractable", new String[]{"true"}).addQueryParam("isfeatured", new String[]{"true"}).addQueryParam("ispublic", new String[]{"true"}).addQueryParam("ostypeid", new String[]{"1234-abcd"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"YpFMYUUu0daLgwxNFubVfkV0Nw8%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
    RegisterISOOptions registerISOOptions = RegisterISOOptions.Builder.accountInDomain((String)"root", (String)"99f4159b-c698-4bd9-b8c5-5ac462f101eb").bootable(true).isExtractable(true).isFeatured(true).isPublic(true).osTypeId("1234-abcd");

    public void testListISOsWhenResponseIs2xx() {
        ISOClient client = (ISOClient)this.requestSendsResponse(this.listIsos, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listisosresponse.json"))).build());
        Assert.assertEquals((String)client.listISOs(new ListISOsOptions[0]).toString(), (String)ImmutableSet.of((Object)iso1, (Object)iso2).toString());
    }

    public void testListISOsWhenResponseIs404() {
        ISOClient client = (ISOClient)this.requestSendsResponse(this.listIsos, HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listISOs(new ListISOsOptions[0]), (Set)ImmutableSet.of());
    }

    public void testListISOsOptionsWhenResponseIs2xx() {
        ISOClient client = (ISOClient)this.requestSendsResponse(this.listIsosOptions, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listisosresponse.json"))).build());
        Assert.assertEquals((String)client.listISOs(new ListISOsOptions[]{ListISOsOptions.Builder.accountInDomain((String)"fred", (String)"5").bootable().hypervisor("xen").id("3").isoFilter(ISO.ISOFilter.featured).isPublic().isReady().keyword("bob").name("bob's iso").zoneId("7")}).toString(), (String)ImmutableSet.of((Object)iso1, (Object)iso2).toString());
    }

    public void testGetISOWhenResponseIs2xx() {
        ISOClient client = (ISOClient)this.requestSendsResponse(this.getIso, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getisoresponse.json"))).build());
        Assert.assertEquals((String)client.getISO("018e0928-8205-4d8e-9329-f731a9ccd488").toString(), (String)iso1.toString());
    }

    public void testGetISOWhenResponseIs404() {
        ISOClient client = (ISOClient)this.requestSendsResponse(this.getIso, HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.getISO("018e0928-8205-4d8e-9329-f731a9ccd488"));
    }

    @Test
    public void testRegisterISOsWhenResponseIs2xx() {
        ISOClient client = (ISOClient)this.requestSendsResponse(this.registerIso, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/registerisoresponse.json"))).build());
        Assert.assertEquals((Object)client.registerISO("ubuntu10.10", "ubuntu 10.10 (32 bit)", "http://ubuntu/ubuntu-10.10.iso", "1e0335d9-b6cc-4805-bddf-0828e66a0d01", new RegisterISOOptions[]{this.registerISOOptions}), (Object)ISO.builder().id("b52c509d-c6e2-452c-b6ec-aa00720ed6cd").name("ubuntu10.10").displayText("ubuntu 10.10 (32 bit)").isPublic(true).isReady(false).bootable(true).isFeatured(false).crossZones(false).osTypeId("0e0335d9-b6cc-4808-bddf-0828e66a0d03").created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2012-08-21T15:45:01+0530")).osTypeName("Ubuntu 10.10 (32-bit)").account("root").domain("ROOT").domainid("99f4159b-c698-4bd9-b8c5-5ac462f101eb").status("").account("admin").zoneId("6f9a2921-b22a-4149-8b71-6ffc275a2177").zoneName("Basic1").isExtractable(false).build());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testRegisterISOWhenResponseIs404() {
        ISOClient client = (ISOClient)this.requestSendsResponse(this.registerIso, HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.registerISO("ubuntu10.10", "ubuntu 10.10 (32 bit)", "http://ubuntu/ubuntu-10.10.iso", "1e0335d9-b6cc-4805-bddf-0828e66a0d01", new RegisterISOOptions[]{this.registerISOOptions}));
    }

    @Override
    protected ISOClient clientFrom(CloudStackContext context) {
        return ((CloudStackClient)context.getProviderSpecificContext().getApi()).getISOClient();
    }
}

