/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.Cluster;
import org.jclouds.cloudstack.domain.Host;
import org.jclouds.cloudstack.options.ListClustersOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListClustersOptionsTest {
    public void testAllocationState() {
        ListClustersOptions options = new ListClustersOptions().allocationState(AllocationState.ENABLED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Enabled"), (Collection)options.buildQueryParameters().get((Object)"allocationstate"));
    }

    public void testAllocationStateStatic() {
        ListClustersOptions options = ListClustersOptions.Builder.allocationState((AllocationState)AllocationState.ENABLED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Enabled"), (Collection)options.buildQueryParameters().get((Object)"allocationstate"));
    }

    public void testClusterType() {
        ListClustersOptions options = new ListClustersOptions().clusterType(Host.ClusterType.CLOUD_MANAGED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"CloudManaged"), (Collection)options.buildQueryParameters().get((Object)"clustertype"));
    }

    public void testClusterTypeStatic() {
        ListClustersOptions options = ListClustersOptions.Builder.clusterType((Host.ClusterType)Host.ClusterType.CLOUD_MANAGED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"CloudManaged"), (Collection)options.buildQueryParameters().get((Object)"clustertype"));
    }

    public void testHypervisor() {
        ListClustersOptions options = new ListClustersOptions().hypervisor("XenServer");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"XenServer"), (Collection)options.buildQueryParameters().get((Object)"hypervisor"));
    }

    public void testHypervisorStatic() {
        ListClustersOptions options = ListClustersOptions.Builder.hypervisor((String)"XenServer");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"XenServer"), (Collection)options.buildQueryParameters().get((Object)"hypervisor"));
    }

    public void testId() {
        ListClustersOptions options = new ListClustersOptions().id("42");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"42"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testIdStatic() {
        ListClustersOptions options = ListClustersOptions.Builder.id((String)"42");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"42"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testKeyword() {
        ListClustersOptions options = new ListClustersOptions().keyword("Enabled");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Enabled"), (Collection)options.buildQueryParameters().get((Object)"keyword"));
    }

    public void testKeywordStatic() {
        ListClustersOptions options = ListClustersOptions.Builder.keyword((String)"Enabled");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Enabled"), (Collection)options.buildQueryParameters().get((Object)"keyword"));
    }

    public void testManagedState() {
        ListClustersOptions options = new ListClustersOptions().managedState(Cluster.ManagedState.PREPARE_UNMANAGED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"PrepareUnmanaged"), (Collection)options.buildQueryParameters().get((Object)"managedstate"));
    }

    public void testManagedStateStatic() {
        ListClustersOptions options = ListClustersOptions.Builder.managedState((Cluster.ManagedState)Cluster.ManagedState.PREPARE_UNMANAGED);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"PrepareUnmanaged"), (Collection)options.buildQueryParameters().get((Object)"managedstate"));
    }

    public void testName() {
        ListClustersOptions options = new ListClustersOptions().name("Host Name");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Host Name"), (Collection)options.buildQueryParameters().get((Object)"name"));
    }

    public void testNameStatic() {
        ListClustersOptions options = ListClustersOptions.Builder.name((String)"Host Name");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Host Name"), (Collection)options.buildQueryParameters().get((Object)"name"));
    }

    public void testPodId() {
        ListClustersOptions options = new ListClustersOptions().podId("42");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"42"), (Collection)options.buildQueryParameters().get((Object)"podid"));
    }

    public void testPodIdStatic() {
        ListClustersOptions options = ListClustersOptions.Builder.podId((String)"42");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"42"), (Collection)options.buildQueryParameters().get((Object)"podid"));
    }

    public void testZoneId() {
        ListClustersOptions options = new ListClustersOptions().zoneId("42");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"42"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }

    public void testZoneIdStatic() {
        ListClustersOptions options = ListClustersOptions.Builder.zoneId((String)"42");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"42"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }
}

