/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jclouds.cloudstack.domain.ISO;
import org.jclouds.cloudstack.options.ListISOsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListISOsOptionsTest {
    private static final Set<String> TRUE = ImmutableSet.of((Object)Boolean.toString(true));
    private static final Set<String> FALSE = ImmutableSet.of((Object)Boolean.toString(false));

    public void testBootable() {
        ListISOsOptions options = new ListISOsOptions().bootable();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"bootable"), TRUE);
    }

    public void testBootableStatic() {
        ListISOsOptions options = ListISOsOptions.Builder.bootable();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"bootable"), TRUE);
    }

    public void testNotBootable() {
        ListISOsOptions options = new ListISOsOptions().notBootable();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"bootable"), FALSE);
    }

    public void testNotBootableStatic() {
        ListISOsOptions options = ListISOsOptions.Builder.notBootable();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"bootable"), FALSE);
    }

    public void testHypervisor() {
        ListISOsOptions options = new ListISOsOptions().hypervisor("KVM");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"hypervisor"), (Collection)ImmutableSet.of((Object)"KVM"));
    }

    public void testHypervisorStatic() {
        ListISOsOptions options = ListISOsOptions.Builder.hypervisor((String)"KVM");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"hypervisor"), (Collection)ImmutableSet.of((Object)"KVM"));
    }

    public void testId() {
        ListISOsOptions options = new ListISOsOptions().id("6");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"id"), (Collection)ImmutableSet.of((Object)"6"));
    }

    public void testIdStatic() {
        ListISOsOptions options = ListISOsOptions.Builder.id((String)"6");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"id"), (Collection)ImmutableSet.of((Object)"6"));
    }

    public void testISOFilter() {
        ListISOsOptions options = new ListISOsOptions().isoFilter(ISO.ISOFilter.community);
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"isofilter"), (Collection)ImmutableSet.of((Object)ISO.ISOFilter.community.name()));
    }

    public void testISOFilterStatic() {
        ListISOsOptions options = ListISOsOptions.Builder.isoFilter((ISO.ISOFilter)ISO.ISOFilter.community);
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"isofilter"), (Collection)ImmutableSet.of((Object)ISO.ISOFilter.community.name()));
    }

    public void testIsPublic() {
        ListISOsOptions options = new ListISOsOptions().isPublic();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"ispublic"), TRUE);
    }

    public void testIsPublicStatic() {
        ListISOsOptions options = ListISOsOptions.Builder.isPublic();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"ispublic"), TRUE);
    }

    public void testIsPrivate() {
        ListISOsOptions options = new ListISOsOptions().isPrivate();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"ispublic"), FALSE);
    }

    public void testIsPrivateStatic() {
        ListISOsOptions options = ListISOsOptions.Builder.isPrivate();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"ispublic"), FALSE);
    }

    public void testIsReady() {
        ListISOsOptions options = new ListISOsOptions().isReady();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"isready"), TRUE);
    }

    public void testIsReadyStatic() {
        ListISOsOptions options = ListISOsOptions.Builder.isReady();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"isready"), TRUE);
    }

    public void testIsNotReady() {
        ListISOsOptions options = new ListISOsOptions().isNotReady();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"isready"), FALSE);
    }

    public void testIsNotReadyStatic() {
        ListISOsOptions options = ListISOsOptions.Builder.isNotReady();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"isready"), FALSE);
    }

    public void testKeyword() {
        ListISOsOptions options = new ListISOsOptions().keyword("text");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"keyword"), (Collection)ImmutableSet.of((Object)"text"));
    }

    public void testKeywordStatic() {
        ListISOsOptions options = ListISOsOptions.Builder.keyword((String)"text");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"keyword"), (Collection)ImmutableSet.of((Object)"text"));
    }

    public void testName() {
        ListISOsOptions options = new ListISOsOptions().name("text");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"name"), (Collection)ImmutableSet.of((Object)"text"));
    }

    public void testNameStatic() {
        ListISOsOptions options = ListISOsOptions.Builder.name((String)"text");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"name"), (Collection)ImmutableSet.of((Object)"text"));
    }

    public void testZoneId() {
        ListISOsOptions options = new ListISOsOptions().zoneId("6");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }

    public void testZoneIdStatic() {
        ListISOsOptions options = ListISOsOptions.Builder.zoneId((String)"6");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }
}

