/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.Domain;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.ListDomainChildrenOptions;
import org.jclouds.cloudstack.options.ListDomainsOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface DomainDomainAsyncClient {
    @Named(value="listDomains")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listDomains", "true"})
    @SelectJson(value={"domain"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Domain>> listDomains(ListDomainsOptions ... var1);

    @Named(value="listDomains")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listDomains", "true"})
    @SelectJson(value={"domain"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Domain> getDomainById(@QueryParam(value="id") String var1);

    @Named(value="listDomainChildren")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listDomainChildren", "true"})
    @SelectJson(value={"domain"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Domain>> listDomainChildren(ListDomainChildrenOptions ... var1);
}

