/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.Domain;
import org.jclouds.cloudstack.features.DomainDomainAsyncClient;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateDomainOptions;
import org.jclouds.cloudstack.options.UpdateDomainOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GlobalDomainAsyncClient
extends DomainDomainAsyncClient {
    @Named(value="createDomain")
    @GET
    @QueryParams(keys={"command"}, values={"createDomain"})
    @SelectJson(value={"domain"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Domain> createDomain(@QueryParam(value="name") String var1, CreateDomainOptions ... var2);

    @Named(value="updateDomain")
    @GET
    @QueryParams(keys={"command"}, values={"updateDomain"})
    @SelectJson(value={"domain"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Domain> updateDomain(@QueryParam(value="id") String var1, UpdateDomainOptions ... var2);

    @Named(value="deleteDomain")
    @GET
    @QueryParams(keys={"command", "cleanup"}, values={"deleteDomain", "false"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteOnlyDomain(@QueryParam(value="id") String var1);

    @Named(value="deleteDomain")
    @GET
    @QueryParams(keys={"command", "cleanup"}, values={"deleteDomain", "true"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteDomainAndAttachedResources(@QueryParam(value="id") String var1);
}

