/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.ApiKeyPair;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.features.DomainUserAsyncClient;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateUserOptions;
import org.jclouds.cloudstack.options.UpdateUserOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GlobalUserAsyncClient
extends DomainUserAsyncClient {
    @Named(value="createUser")
    @GET
    @QueryParams(keys={"command"}, values={"createUser"})
    @SelectJson(value={"user"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<User> createUser(@QueryParam(value="username") String var1, @QueryParam(value="account") String var2, @QueryParam(value="email") String var3, @QueryParam(value="password") String var4, @QueryParam(value="firstname") String var5, @QueryParam(value="lastname") String var6, CreateUserOptions ... var7);

    @Named(value="registerUserKeys")
    @GET
    @QueryParams(keys={"command"}, values={"registerUserKeys"})
    @SelectJson(value={"userkeys"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<ApiKeyPair> registerUserKeys(@QueryParam(value="id") String var1);

    @Named(value="updateUser")
    @GET
    @QueryParams(keys={"command"}, values={"updateUser"})
    @SelectJson(value={"user"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<User> updateUser(@QueryParam(value="id") String var1, UpdateUserOptions ... var2);

    @Named(value="deleteUser")
    @GET
    @QueryParams(keys={"command"}, values={"deleteUser"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteUser(@QueryParam(value="id") String var1);
}

