/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.binders.BindIdListToCommaDelimitedQueryParam;
import org.jclouds.cloudstack.binders.BindSnapshotPolicyScheduleToQueryParam;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.Snapshot;
import org.jclouds.cloudstack.domain.SnapshotPolicy;
import org.jclouds.cloudstack.domain.SnapshotPolicySchedule;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateSnapshotOptions;
import org.jclouds.cloudstack.options.ListSnapshotPoliciesOptions;
import org.jclouds.cloudstack.options.ListSnapshotsOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface SnapshotAsyncClient {
    @Named(value="createSnapshot")
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"createSnapshot"})
    @Unwrap
    public ListenableFuture<AsyncCreateResponse> createSnapshot(@QueryParam(value="volumeid") String var1, CreateSnapshotOptions ... var2);

    @Named(value="listSnapshots")
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command", "listAll"}, values={"listSnapshots", "true"})
    @SelectJson(value={"snapshot"})
    @Unwrap
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Snapshot>> listSnapshots(ListSnapshotsOptions ... var1);

    @Named(value="listSnapshots")
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command", "listAll"}, values={"listSnapshots", "true"})
    @SelectJson(value={"snapshot"})
    @OnlyElement
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Snapshot> getSnapshot(@QueryParam(value="id") String var1);

    @Named(value="deleteSnapshot")
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"deleteSnapshot"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteSnapshot(@QueryParam(value="id") String var1);

    @Named(value="createSnapshotPolicy")
    @GET
    @Consumes(value={"application/json"})
    @Unwrap
    @QueryParams(keys={"command"}, values={"createSnapshotPolicy"})
    public ListenableFuture<SnapshotPolicy> createSnapshotPolicy(@BinderParam(value=BindSnapshotPolicyScheduleToQueryParam.class) SnapshotPolicySchedule var1, @QueryParam(value="maxsnaps") String var2, @QueryParam(value="timezone") String var3, @QueryParam(value="volumeid") String var4);

    @Named(value="deleteSnapshotPolicies")
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"deleteSnapshotPolicies"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteSnapshotPolicy(@QueryParam(value="id") String var1);

    @Named(value="deleteSnapshotPolicies")
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"deleteSnapshotPolicies"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteSnapshotPolicies(@BinderParam(value=BindIdListToCommaDelimitedQueryParam.class) Iterable<String> var1);

    @Named(value="listSnapshotPolicies")
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command", "listAll"}, values={"listSnapshotPolicies", "true"})
    @Unwrap
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<SnapshotPolicy>> listSnapshotPolicies(@QueryParam(value="volumeid") String var1, ListSnapshotPoliciesOptions ... var2);
}

