/*
 * Decompiled with CFR 0.152.
 */
package org.moormanity.smpte.timecode;

import lombok.NonNull;

public enum FrameRate {
    _23_976("23.976 fps", 24000, 1001, 24, false, 0),
    _24("24 fps", 24, 1, 24, false, 0),
    _24_98("24.98 fps", 25000, 1001, 25, false, 0),
    _25("25 fps", 25, 1, 25, false, 0),
    _29_97("29.97 fps", 30000, 1001, 30, false, 0),
    _29_97_drop("29.97 fps drop", 30000, 1001, 30, true, 2),
    _30("30", 30, 1, 30, false, 0),
    _30_drop("30 drop", 3, 1, 30, true, 2),
    _47_952("47.952 fps", 48000, 1001, 48, false, 0),
    _48("48 fps", 48, 1, 48, false, 0),
    _50("50 fps", 50, 1, 50, false, 0),
    _59_94("59.94 fps", 60000, 1001, 60, false, 0),
    _59_94_drop("59.94 fps drop", 60000, 1001, 60, true, 4),
    _60("60 fps", 60, 1, 60, false, 0),
    _60_drop("60 fps drop", 60, 1, 60, true, 4),
    _100("100 fps", 100, 1, 100, false, 0),
    _119_88("119.88 fps", 120000, 1001, 120, false, 0),
    _119_88_drop("119.88 fps", 120000, 1001, 120, true, 4),
    _120("120 fps", 120, 1, 120, false, 0),
    _120_drop("120 fps", 120, 1, 120, true, 8);

    @NonNull
    private final String name;
    private final int numeratorForRealTimeFrameRate;
    private final int denominatorForRealTimeFrameRate;
    private final int numberOfElapsedFramesThatCompriseOneSecond;
    private final boolean isDropFrameMode;
    private final int numberOfFramesToDropInOneMinute;

    public double frameRateForElapsedFramesCalculation() {
        switch (this) {
            case _29_97_drop: {
                return 29.97;
            }
            case _59_94_drop: {
                return 59.94;
            }
            case _60_drop: {
                return 59.94;
            }
            case _119_88_drop: {
                return 119.88;
            }
            case _120_drop: {
                return 119.88;
            }
        }
        return this.getNumberOfElapsedFramesThatCompriseOneSecond();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public int getNumeratorForRealTimeFrameRate() {
        return this.numeratorForRealTimeFrameRate;
    }

    public int getDenominatorForRealTimeFrameRate() {
        return this.denominatorForRealTimeFrameRate;
    }

    public int getNumberOfElapsedFramesThatCompriseOneSecond() {
        return this.numberOfElapsedFramesThatCompriseOneSecond;
    }

    public boolean isDropFrameMode() {
        return this.isDropFrameMode;
    }

    public int getNumberOfFramesToDropInOneMinute() {
        return this.numberOfFramesToDropInOneMinute;
    }

    private FrameRate(String name, int numeratorForRealTimeFrameRate, int denominatorForRealTimeFrameRate, int numberOfElapsedFramesThatCompriseOneSecond, boolean isDropFrameMode, int numberOfFramesToDropInOneMinute) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.numeratorForRealTimeFrameRate = numeratorForRealTimeFrameRate;
        this.denominatorForRealTimeFrameRate = denominatorForRealTimeFrameRate;
        this.numberOfElapsedFramesThatCompriseOneSecond = numberOfElapsedFramesThatCompriseOneSecond;
        this.isDropFrameMode = isDropFrameMode;
        this.numberOfFramesToDropInOneMinute = numberOfFramesToDropInOneMinute;
    }
}

