/*
 * Decompiled with CFR 0.152.
 */
package org.moormanity.smpte.timecode;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.moormanity.smpte.timecode.FrameRate;
import org.moormanity.smpte.timecode.TimecodeRecord;

public class TimecodeOperations {
    private static final Pattern TIMECODE_STRING_PATTERN = Pattern.compile("([0-9][0-9]):([0-5][0-9]):([0-5][0-9])[:;]([0-9][0-9])");

    public static TimecodeRecord fromTimecodeString(@NonNull String timecodeString, @NonNull FrameRate frameRate) {
        if (timecodeString == null) {
            throw new NullPointerException("timecodeString is marked non-null but is null");
        }
        if (frameRate == null) {
            throw new NullPointerException("frameRate is marked non-null but is null");
        }
        Matcher matcher = TIMECODE_STRING_PATTERN.matcher(timecodeString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Could not parse timecode string: " + timecodeString);
        }
        int hours = Integer.parseInt(matcher.group(1));
        int minutes = Integer.parseInt(matcher.group(2));
        int seconds = Integer.parseInt(matcher.group(3));
        int frames = Integer.parseInt(matcher.group(4));
        if (frames >= frameRate.getNumberOfElapsedFramesThatCompriseOneSecond()) {
            throw new IllegalArgumentException("Timecode string is not suitable for given framerate. frame " + frames + " is out of range of " + frameRate.getName());
        }
        return new TimecodeRecord(hours, minutes, seconds, frames, frameRate);
    }

    public static String toTimecodeString(@NonNull TimecodeRecord a) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        String template = a.getFrameRate().getNumberOfElapsedFramesThatCompriseOneSecond() > 100 ? "%02d:%02d:%02d%s%03d" : "%02d:%02d:%02d%s%02d";
        return String.format(template, a.getHours(), a.getMinutes(), a.getSeconds(), a.getFrameRate().isDropFrameMode() ? ";" : ":", a.getFrames());
    }

    public static TimecodeRecord fromElapsedFrames(int elapsedFrames, @NonNull FrameRate frameRate) {
        if (frameRate == null) {
            throw new NullPointerException("frameRate is marked non-null but is null");
        }
        if (elapsedFrames < 0) {
            throw new IllegalArgumentException("frameNumber must be positive: " + elapsedFrames);
        }
        double framesPer10Minutes = frameRate.frameRateForElapsedFramesCalculation() * 600.0;
        int d = (int)((double)elapsedFrames / framesPer10Minutes);
        int m = (int)((double)elapsedFrames % framesPer10Minutes);
        int f = Math.max(0, m - frameRate.getNumberOfFramesToDropInOneMinute());
        int part1 = 9 * frameRate.getNumberOfFramesToDropInOneMinute() * d;
        int part2 = frameRate.getNumberOfFramesToDropInOneMinute() * (int)((double)f / ((framesPer10Minutes - (double)frameRate.getNumberOfFramesToDropInOneMinute()) / 10.0));
        int adjustedElapsedFrames = elapsedFrames + part1 + part2;
        int logicalFps = frameRate.getNumberOfElapsedFramesThatCompriseOneSecond();
        int frames = adjustedElapsedFrames % logicalFps;
        int seconds = adjustedElapsedFrames / logicalFps % 60;
        int minutes = adjustedElapsedFrames / (logicalFps * 60) % 60;
        int hours = adjustedElapsedFrames / (logicalFps * 3600) % 24;
        return new TimecodeRecord(hours, minutes, seconds, frames, frameRate);
    }

    public static int toElapsedFrameCount(@NonNull TimecodeRecord a) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        int totalMinutes = 60 * a.getHours() + a.getMinutes();
        int frameRateForElapsedFramesCalculation = a.getFrameRate().getNumberOfElapsedFramesThatCompriseOneSecond();
        int base = frameRateForElapsedFramesCalculation * 60 * 60 * a.getHours() + frameRateForElapsedFramesCalculation * 60 * a.getMinutes() + frameRateForElapsedFramesCalculation * a.getSeconds() + a.getFrames();
        int dropOffset = a.getFrameRate().getNumberOfFramesToDropInOneMinute() * (totalMinutes - totalMinutes / 10);
        return base - dropOffset;
    }

    public static TimecodeRecord add(@NonNull TimecodeRecord a, @NonNull TimecodeRecord b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        if (a.getFrameRate() != b.getFrameRate()) {
            throw new IllegalArgumentException("frame rates must match");
        }
        return TimecodeOperations.fromElapsedFrames(TimecodeOperations.toElapsedFrameCount(a) + TimecodeOperations.toElapsedFrameCount(b), a.getFrameRate());
    }

    public static TimecodeRecord subtract(@NonNull TimecodeRecord a, @NonNull TimecodeRecord b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        if (a.getFrameRate() != b.getFrameRate()) {
            throw new IllegalArgumentException("frame rates must match");
        }
        return TimecodeOperations.fromElapsedFrames(TimecodeOperations.toElapsedFrameCount(a) - TimecodeOperations.toElapsedFrameCount(b), a.getFrameRate());
    }

    private TimecodeOperations() {
    }
}

